//
// automatically generated by spin2cpp v3.4.0-beta on Mon Nov 14 09:24:09 2016
// spin2cpp --ccode --gas s3.spin 
//

// :::::::[ Driver Object for the Scribbler Robot Models S2 & S3 ]:::::::::::::::::::::::::::::::::
/* {
┌───────────────────────────────────────┐
│          Scribbler Object             │
│(c) Copyright 2010 Bueno Systems, Inc. │
│   See end of file for terms of use.   │
└───────────────────────────────────────┘
This object provides both high- and low-level drivers for the
Parallax Scribbler S2 & S3 robots.

Version History
───────────────

2010.09.16: Initial Version 1(M) release
2010.09.28: Version 1(N) release:
              Fixed bug in _ee* Spin routines.
              Upped size of sound buffer to 1200.
              Added calibration methods for light sensors.
              Added 1/2 sec. delay to start routine.
2010.10.18:   Added check for zero time in play_tone.
2010.10.25:   Added log response method for light sensors.
2010.10.27: Version 1(O) release:
              Added methods to save default line sensor threshold.
2010.10.28:   Fixed bugs in calibration methods.
2010.11.15: Version 1(P) release:
              Added self-documentation features.
              Added sensitivity setting for obstacle detection.

2015.03.11: Ben Wirz - modified the original S2 object to suport both the S2 & S3
              Renamed to the scribbler object from the S2 object.
              Added support for detecting the hardware model number.
              Added support for the S3's different EEPROM type and layout.
              Added basic support for controlling the battery charger IC.
              
                            
 */
/* =======[ Introduction ]=========================================================

scribbler.spin provides low-level drivers for the Scribblers's various functions, as
well as top-level access functions to interface with those drivers. Driver functions
are separated into four additional cogs:
''
''  1. Analog, button, and LED drivers.
''  2. Motor driver.
''  3. Sound sequencer and synthesizer.
''  4. Microphone envelope detector.
''
Driver #1 is required and is started with the scribbler object's main `start method.
The other drivers are optional, depending upon the user's requirements, and have their
own start methods (`start_motors, `start_tones, `start_mic_env). The scribbler object's
`stop method stops all driver cogs which have been started.

The analog, button, and LED drivers are the heartbeat of the system. The analog
driver continuously cycles through sixteen analog inputs and updates their states
with a one-millisecond cycle time. The button driver monitors the state
of the scribblers's single pushbutton and, depending on the user-selected button mode, can
cause it to reset the scribbler, while displaying the button-press count on the LEDs, and
record the number of button presses in EEPROM for use by the newly-restarted user
program. The LED driver manages the LEDs' polarity and PWMing to provide various
shades and hues from the scribbler's red/green LEDs and blue power LED. It doesn this via
the LEDs' shift register port.

 */
// =======[ Constants... ]=========================================================
#include <stdlib.h>
#include <propeller.h>
#undef clkset
#undef cogid
#undef cogstop
#undef locknew
#undef lockret
#undef lockclr
#undef lockset
#undef waitcnt
#undef waitpeq
#undef waitpne
#define _waitcnt(x) __builtin_propeller_waitcnt((x), 0)
#include "scribbler.h"

#ifdef __GNUC__
#define INLINE__ static inline
#define Yield__() __asm__ volatile( "" ::: "memory" )
#define BitEncode__(X) (32 - __builtin_clz(X))
#else
#define INLINE__ static
#define Yield__()
#define waitcnt(n) _waitcnt(n)
#define coginit(id, code, par) _coginit((unsigned)(par)>>2, (unsigned)(code)>>2, id)
#define cognew(code, par) coginit(0x8, (code), (par))
#define cogstop(i) _cogstop(i)
INLINE__ int32_t BitEncode__(uint32_t a) {
  int r=0;
  while (a != 0) { a = a>>1; r++; }
  return r;
}
#endif

INLINE__ int32_t Min__(int32_t a, int32_t b) { return a < b ? a : b; }
INLINE__ int32_t Max__(int32_t a, int32_t b) { return a > b ? a : b; }
INLINE__ int32_t Shr__(uint32_t a, uint32_t b) { return (a>>b); }
INLINE__ int32_t Lookdown__(int32_t x, int32_t b, int32_t a[], int32_t n) { int32_t i, r; r = 0; for (i = 0; i < n; i++) { if (a[i] == x) { r = i+b; break; } }; return r; }

static uint32_t Sqrt__(uint32_t a) {
    uint32_t res = 0;
    uint32_t bit = 1<<30;
    while (bit > a) bit = bit>>2;
    while (bit != 0) {
        if (a >= res+bit) {
            a = a - (res+bit);
            res = (res>>1) + bit;
        } else res = res >> 1;
        bit = bit >> 2;
    }
    return res;
}
static  void scribbler__compute_calibration(void);
static  int32_t scribbler__atan2(int32_t y, int32_t x);
static  int32_t scribbler__enqueue_tone(int32_t tone_word);
static  int32_t scribbler__i2c_rd(int32_t acknak);
static  int32_t scribbler__i2c_wr(int32_t data);
static  void scribbler__i2c_start(void);
static  void scribbler__i2c_stop(void);
static  int32_t scribbler__ee_rdblock(int32_t dest_addr, int32_t addr, int32_t size);
static  int32_t scribbler__ee_wrblock(int32_t src_addr, int32_t addr, int32_t size);
static  int32_t scribbler__ee_rdbyte(int32_t addr);
static  int32_t scribbler__ee_wrbyte(int32_t addr, int32_t data);
static  void scribbler__ee_waddr(int32_t addr);
static  int32_t scribbler__BQ2495_rdbyte(int32_t addr);
static  int32_t scribbler__BQ2495_wrbyte(int32_t addr, int32_t data);
static  void scribbler__BQ2495_waddr(int32_t addr);

extern uint8_t _dat_scribbler_[] __asm__("..dat_start");
#define _tostr__(...) #__VA_ARGS__
#define _tostr_(...) _tostr__(__VA_ARGS__)
#define _dat_(...) __asm__(_tostr_(__VA_ARGS__) "\n")
#define _lbl_(x) (x - _org_)
#define _org_ ..dat_start
extern int32_t env_det[] __asm__("env_det");
extern int32_t mic_cyc[] __asm__("mic_cyc");
extern int32_t mic_dt[] __asm__("mic_dt");
extern int32_t tone_seq[] __asm__("tone_seq");
extern int32_t dttime[] __asm__("dttime");
extern int32_t queue_addr[] __asm__("queue_addr");
extern int32_t adc_all[] __asm__("adc_all");
extern int32_t results_addr[] __asm__("results_addr");
extern int32_t seq_addr[] __asm__("seq_addr");
extern int32_t motor_driver[] __asm__("motor_driver");
extern int32_t midler_addr[] __asm__("midler_addr");
extern uint16_t Adc_sequence[] __asm__("Adc_sequence");
extern int32_t Timers[] __asm__("Timers");
extern int32_t Envelope[] __asm__("Envelope");
extern int32_t Current_x[] __asm__("Current_x");
extern int32_t Current_y[] __asm__("Current_y");
extern int32_t Current_w[] __asm__("Current_w");
extern int32_t Stall_hyst[] __asm__("Stall_hyst");
extern uint16_t Full_circle[] __asm__("Full_circle");
extern uint16_t Wheel_space[] __asm__("Wheel_space");
extern uint16_t Half_circle[] __asm__("Half_circle");
extern uint16_t Qtr_circle[] __asm__("Qtr_circle");
extern int32_t Atan_circle[] __asm__("Atan_circle");
extern uint8_t Light_scale[] __asm__("Light_scale");
extern uint8_t Line_thld[] __asm__("Line_thld");
extern uint8_t Obstacle_thld[] __asm__("Obstacle_thld");
extern uint16_t Motor_cmd[] __asm__("Motor_cmd") __attribute__((aligned(4)));
extern uint16_t Motor_Rdist[] __asm__("Motor_Rdist") __attribute__((aligned(4)));
extern uint16_t Motor_Ldist[] __asm__("Motor_Ldist");
extern int32_t Motor_stat[] __asm__("Motor_stat");
extern int32_t Path_Rdist[] __asm__("Path_Rdist");
extern int32_t Path_Ldist[] __asm__("Path_Ldist");
extern int32_t Path_time[] __asm__("Path_time");
extern int32_t Path_max_spd[] __asm__("Path_max_spd");
extern uint16_t Results[] __asm__("Results");
extern uint16_t Tone_queue[] __asm__("Tone_queue");
extern uint16_t Tone_enq_ptr[] __asm__("Tone_enq_ptr");
extern uint16_t Tone_deq_ptr[] __asm__("Tone_deq_ptr");
extern uint8_t Tone_cmd[] __asm__("Tone_cmd");
extern uint8_t Tone_sync[] __asm__("Tone_sync");
extern uint8_t Tone_voice1[] __asm__("Tone_voice1");
extern uint8_t Tone_voice2[] __asm__("Tone_voice2");
extern uint8_t In_path[] __asm__("In_path");
extern uint8_t Adc_cog[] __asm__("Adc_cog");
extern uint8_t Tone_cog[] __asm__("Tone_cog");
extern uint8_t Mic_cog[] __asm__("Mic_cog");
extern uint8_t Motor_cog[] __asm__("Motor_cog");
extern uint8_t Reset_count[] __asm__("Reset_count");
extern uint8_t Current_spd[] __asm__("Current_spd");
extern uint8_t Model_number[] __asm__("Model_number");
_dat_(            .section .scribbler.dat,"ax"                        );
_dat_(            .compress off                                       );
_dat_(  ..dat_start:                                                  );
                  // -------[ Microphone ]-----------------------------------------------

#undef _org_
#define _org_ ..org0001
_dat_(..org0001_base = . + 0x0                                        );
_dat_(  env_det:                                                      );
                  // Set up ctra for sigma-delta ADC.
_dat_(            mov     ctra, _lbl_(mic_ctra0)                      );
_dat_(            mov     dira, _lbl_(mic_dira0)                      );
_dat_(            mov     frqa, #1                                    );
                  // Guess at adc bias level:
_dat_(            mov     _lbl_(mic_bias), _lbl_(mic_dt)              );
                  //  dt / 2.
_dat_(            shr     _lbl_(mic_bias), #1                         );
                  // Initialize interval timer.
_dat_(            mov     _lbl_(mic_time), cnt                        );
_dat_(            add     _lbl_(mic_time), _lbl_(mic_dt)              );
                  // Save baseline value.
_dat_(            mov     _lbl_(mic_pamp), phsa                       );
_dat_(  env_lp:                                                       );
                  // Initialize the Envelope for this major cycle.
_dat_(            mov     _lbl_(mic_acc), #0                          );
                  // Initialize the sample count for this cycle.
_dat_(            mov     _lbl_(mic_cnt), _lbl_(mic_cyc)              );
_dat_(  mic_lp:                                                       );
                  // Sample the mic input.
_dat_(            jmpret  _lbl_(mic_samp_ret), #_lbl_(mic_samp)       );
                  // Add its abs value to Envelope.
_dat_(            addabs  _lbl_(mic_acc), _lbl_(mic_amp)              );
                  // Back for another sample.
_dat_(            djnz    _lbl_(mic_cnt), #_lbl_(mic_lp)              );
                  // Write the Envelope value to hub.
_dat_(            wrlong  _lbl_(mic_acc), par                         );
                  // Back for another cycle.
_dat_(            jmp     #_lbl_(env_lp)                              );
_dat_(  mic_samp:                                                     );
                  // -------[ Microphone sample routine ]------------------------------------------
                  //    Read the ADC (microphone) input.
                  // Wait for adc value to be accumulated.
_dat_(            waitcnt _lbl_(mic_time), _lbl_(mic_dt)              );
                  // Read it.
_dat_(            mov     _lbl_(mic_amp), phsa                        );
                  // Subtract the previous reading.
_dat_(            sub     _lbl_(mic_amp), _lbl_(mic_pamp)             );
                  // pamp := pamp + amp - pamp == pamp
_dat_(            add     _lbl_(mic_pamp), _lbl_(mic_amp)             );
                  // Subtract the DC bias.
_dat_(            sub     _lbl_(mic_amp), _lbl_(mic_bias)             );
                  // Compute running average of bias.
_dat_(            shl     _lbl_(mic_bias), #4                         );
_dat_(            add     _lbl_(mic_bias), _lbl_(mic_amp)             );
_dat_(            shr     _lbl_(mic_bias), #4                         );
_dat_(  mic_samp_ret:                                                 );
_dat_(            ret                                                 );
_dat_(  mic_cyc:                                                      );
_dat_(            .long   (0 - 0)                                     );
_dat_(  mic_dt:                                                       );
_dat_(            .long   (0 - 0)                                     );
_dat_(  mic_dira0:                                                    );
_dat_(            .long   (1 << SCRIBBLER_MIC_ADC_OUT)                );
_dat_(  mic_ctra0:                                                    );
_dat_(            .long   (((9 << $1a) | (SCRIBBLER_MIC_ADC_OUT << 9)) | SCRIBBLER_MIC_ADC_IN));
_dat_(  mic_bias:                                                     );
_dat_(            .res    1                                           );
_dat_(  mic_acc:                                                      );
_dat_(            .res    1                                           );
_dat_(  mic_cnt:                                                      );
_dat_(            .res    1                                           );
_dat_(  mic_time:                                                     );
_dat_(            .res    1                                           );
_dat_(  mic_pamp:                                                     );
_dat_(            .res    1                                           );
_dat_(  mic_amp:                                                      );
_dat_(            .res    1                                           );
_dat_(            .fit    $1f0                                        );
                  // -------[ Tone Player ]-------------------------------------------------------

#undef _org_
#define _org_ ..org0002
_dat_(..org0002_base = . + 0x0                                        );
_dat_(  tone_seq:                                                     );
                  // Initialize counter for DUTY mode.
_dat_(            mov     ctra, _lbl_(tctra0)                         );
_dat_(            mov     _lbl_(tacc), _lbl_(queue_addr)              );
_dat_(            add     _lbl_(tacc), _lbl_(queue_size)              );
_dat_(            add     _lbl_(tacc), _lbl_(queue_size)              );
_dat_(            mov     _lbl_(enq_ptr_addr), _lbl_(tacc)            );
_dat_(            add     _lbl_(tacc), #2                             );
_dat_(            mov     _lbl_(deq_ptr_addr), _lbl_(tacc)            );
_dat_(            add     _lbl_(tacc), #2                             );
_dat_(            mov     _lbl_(cmd_addr), _lbl_(tacc)                );
_dat_(            add     _lbl_(tacc), #1                             );
_dat_(            mov     _lbl_(sync_addr), _lbl_(tacc)               );
_dat_(            mov     _lbl_(ttime), cnt                           );
_dat_(            add     _lbl_(ttime), _lbl_(dttime)                 );
_dat_(  Tone_seq_get_cmd:                                             );
                  // Get the next word from queue.
_dat_(            jmpret  _lbl_(dequeue_ret), #_lbl_(dequeue)         );
                  // Copy word to command.
_dat_(            mov     _lbl_(cmd), _lbl_(tacc)                     );
                  // Isolate the 13 data bits.
_dat_(            and     _lbl_(tacc), _lbl_(data_bits)               );
                  // Isolate command bits. Is command == TONE?
_dat_(            shr     _lbl_(cmd), #$d    wz                       );
                  //  Yes: Go make some noise. 
_dat_(  if_z      jmp     #_lbl_(Tone_seq_tone)                       );
                  // Is command a set volume?
_dat_(            cmp     _lbl_(cmd), #SCRIBBLER_VOLU    wz           );
_dat_(  if_nz     jmp     #_lbl_(Tone_seq_try_sync)                   );
                  //  Yes: Normalize the volume value,
_dat_(            shl     _lbl_(tacc), #3                             );
                  //         and save it.
_dat_(            mov     _lbl_(volume), _lbl_(tacc)                  );
                  //       Back for anohter command.
_dat_(            jmp     #_lbl_(Tone_seq_get_cmd)                    );
_dat_(  Tone_seq_try_sync:                                            );
                  // Is command a sync?            
_dat_(            cmp     _lbl_(cmd), #SCRIBBLER_SYNC    wz           );
                  //  Yes: go do it.
_dat_(  if_z      jmp     #_lbl_(Tone_seq_do_sync)                    );
                  // Is command a pause-and-sync?
_dat_(            cmp     _lbl_(cmd), #SCRIBBLER_PAUS    wz           );
                  //  No:  Invalid command; just skip it.
_dat_(  if_nz     jmp     #_lbl_(Tone_seq_get_cmd)                    );
                  //  Yes: Stop playing.
_dat_(            mov     _lbl_(playing), #0                          );
_dat_(  Tone_seq_do_sync:                                             );
                  //       Copy the sync value back to hub variable.
_dat_(            wrbyte  _lbl_(tacc), _lbl_(sync_addr)               );
                  //       Back for another command.              
_dat_(            jmp     #_lbl_(Tone_seq_get_cmd)                    );
_dat_(  Tone_seq_tone:                                                );
                  // Multiply duration by 65 to get
_dat_(            mov     _lbl_(duration), _lbl_(tacc)                );
                  //  approx milliseconds (within 1%)
_dat_(            shl     _lbl_(tacc), #6                             );
_dat_(            add     _lbl_(duration), _lbl_(tacc)                );
_dat_(            shr     _lbl_(duration), #1                         );
                  // Get the freq1 value.
_dat_(            jmpret  _lbl_(dequeue_ret), #_lbl_(dequeue)         );
_dat_(            mov     _lbl_(freq1), _lbl_(tacc)                   );
                  // Isolate the frequency part.
_dat_(            shl     _lbl_(freq1), #$12    wz                    );
                  // Is it zero?
_dat_(            shr     _lbl_(freq1), #1                            );
                  //  Yes: Zero the phase, too.
_dat_(  if_z      mov     _lbl_(phase1), #0                           );
                  // Isolate the voice part.
_dat_(            mov     _lbl_(voice1), _lbl_(tacc)                  );
_dat_(            shr     _lbl_(voice1), #$e                          );
                  // Get the freq2 value and process the same.
_dat_(            jmpret  _lbl_(dequeue_ret), #_lbl_(dequeue)         );
_dat_(            mov     _lbl_(freq2), _lbl_(tacc)                   );
_dat_(            shl     _lbl_(freq2), #$12    wz                    );
_dat_(            shr     _lbl_(freq2), #1                            );
_dat_(  if_z      mov     _lbl_(phase2), #0                           );
_dat_(            mov     _lbl_(voice2), _lbl_(tacc)                  );
_dat_(            shr     _lbl_(voice2), #$e                          );
_dat_(            or      dira, _lbl_(tdira0)                         );
_dat_(  Tone_seq_tone_lp:                                             );
                  // Tone generation: first check for a STOP.
_dat_(            rdbyte  _lbl_(tacc), _lbl_(cmd_addr)                );
                  // Is it a STOP?
_dat_(            cmp     _lbl_(tacc), #SCRIBBLER_STOP    wz          );
                  //  Yes: Quit, and let dequeue handle it.
_dat_(  if_z      jmp     #_lbl_(Tone_seq_get_cmd)                    );
                  // Tone generation: Increment the phases.
_dat_(            add     _lbl_(phase1), _lbl_(freq1)                 );
_dat_(            add     _lbl_(phase2), _lbl_(freq2)                 );
                  // Get the first phase and voice.
_dat_(            mov     _lbl_(phase), _lbl_(phase1)                 );
_dat_(            mov     _lbl_(voice), _lbl_(voice1)                 );
                  // Compute current amplitude.
_dat_(            jmpret  _lbl_(get_amp_ret), #_lbl_(get_amp)         );
                  // Copy amplitude to amp.
_dat_(            mov     _lbl_(amp), _lbl_(tacc)                     );
                  // Get the second phase and voice.
_dat_(            mov     _lbl_(phase), _lbl_(phase2)                 );
_dat_(            mov     _lbl_(voice), _lbl_(voice2)                 );
                  // Compute the current amplitude.
_dat_(            jmpret  _lbl_(get_amp_ret), #_lbl_(get_amp)         );
                  // Add to the first amplitude.
_dat_(            add     _lbl_(amp), _lbl_(tacc)                     );
                  // Multiply the instantenous abs amplitude by the volume.
_dat_(            abs     _lbl_(tacc), _lbl_(amp)                     );
_dat_(            mov     _lbl_(taccx), _lbl_(volume)                 );
_dat_(            jmpret  _lbl_(fmult_ret), #_lbl_(fmult)             );
                  // Get the original sign of amp in carry.
_dat_(            shl     _lbl_(amp), #1    wc                        );
                  // Zero level is Vdd/2.
_dat_(            mov     _lbl_(amp), _lbl_(amp0)                     );
                  // Fix the sign and add to zero level.
_dat_(            sumc    _lbl_(amp), _lbl_(tacc)                     );
                  // Wait for sample interval.
_dat_(            waitcnt _lbl_(ttime), _lbl_(dttime)                 );
                  // Output the amplitude to DUTY-mode counter.
_dat_(            mov     frqa, _lbl_(amp)                            );
                  // Count down the duration and repeat.
_dat_(            djnz    _lbl_(duration), #_lbl_(Tone_seq_tone_lp)   );
                  // Get the next command.
_dat_(            jmp     #_lbl_(Tone_seq_get_cmd)                    );
_dat_(  get_amp:                                                      );
                  // -------[ Compute the instantaneous amplitude for one component. ]-------------              
                  // Test for waveform type.
_dat_(            test    _lbl_(voice), #2    wc                      );
_dat_(            test    _lbl_(voice), #1    wz                      );
                  // Jump to appropriate sections based on waveform.
_dat_(  if_c      jmp     #_lbl_(Get_amp_tri_sin)                     );
_dat_(  if_nz     jmp     #_lbl_(Get_amp_saw)                         );
_dat_(  Get_amp_squ:                                                  );
                  // Square wave: Test sign bit of phase.
_dat_(            shl     _lbl_(phase), #1    wc, nr                  );
                  // Add or subtract max based on sign
_dat_(            negc    _lbl_(tacc), _lbl_(maxamp)                  );
                  // Return.
_dat_(            jmp     _lbl_(get_amp_ret)                          );
_dat_(  Get_amp_saw:                                                  );
                  // Sawtooth wave: Get the phase.
_dat_(            mov     _lbl_(tacc), _lbl_(phase)                   );
                  // Convert to signed.
_dat_(            add     _lbl_(tacc), _lbl_(amp0)                    );
                  // Signed divide by two.
_dat_(            sar     _lbl_(tacc), #1                             );
                  // Return.
_dat_(            jmp     _lbl_(get_amp_ret)                          );
_dat_(  Get_amp_tri_sin:                                              );
_dat_(  if_nz     jmp     #_lbl_(Get_amp_sin)                         );
_dat_(  Get_amp_tri:                                                  );
                  // Triangle wave: Get abs value.
_dat_(            abs     _lbl_(tacc), _lbl_(phase)                   );
                  // Convert to pos and neg values.
_dat_(            sub     _lbl_(tacc), _lbl_(maxamp)                  );
                  // Return.
_dat_(            jmp     _lbl_(get_amp_ret)                          );
_dat_(  Get_amp_sin:                                                  );
                  // Get 13-bit angle.
_dat_(            shr     _lbl_(phase), #($20 - $d)                   );
                  // Get sine quadrant 3|4 into nz.
_dat_(            test    _lbl_(phase), _lbl_(_0x1000)    wz          );
                  // Get sine quadrant 2|4 into c.
_dat_(            test    _lbl_(phase), _lbl_(_0x0800)    wc          );
                  // If sine quadrant 2|4, negate table offset.
_dat_(            negc    _lbl_(phase), _lbl_(phase)                  );
                  // Insert sine table base address >> 1.
_dat_(            or      _lbl_(phase), _lbl_(_0x7000)                );
                  // Shift left to get final word address.
_dat_(            shl     _lbl_(phase), #1                            );
                  // Read sine word from table.
_dat_(            rdword  _lbl_(tacc), _lbl_(phase)                   );
                  // If quadrant 3|4, negate word.
_dat_(            negnz   _lbl_(tacc), _lbl_(tacc)                    );
                  // Msb-justify result.
_dat_(            shl     _lbl_(tacc), #$e                            );
_dat_(  get_amp_ret:                                                  );
_dat_(            ret                                                 );
_dat_(  dequeue:                                                      );
                  // -------[ Dequeue next word in sequence. ]-------------------------------------
                  // Check for an immediate command first.
_dat_(            rdbyte  _lbl_(tacc), _lbl_(cmd_addr)                );
                  // Is it a PAUSE?
_dat_(            cmp     _lbl_(tacc), #SCRIBBLER_PAUSE    wz         );
                  //  No:  Is it a STOP?
_dat_(  if_nz     cmp     _lbl_(tacc), #SCRIBBLER_STOP    wz          );
                  //  Yes:   Yes: Clear Playing flag.
_dat_(  if_z      mov     _lbl_(playing), #0                          );
                  //              Go clear command.
_dat_(  if_z      jmp     #_lbl_(Dequeue_zapcmd)                      );
                  //         No:  Is it a PLAY?
_dat_(            cmp     _lbl_(tacc), #SCRIBBLER_PLAY    wz          );
                  //                Yes: Set playing flag.
_dat_(  if_z      mov     _lbl_(playing), #1                          );
_dat_(  Dequeue_zapcmd:                                               );
                  //       Clear the command.
_dat_(  if_z      wrbyte  _lbl_(zero), _lbl_(cmd_addr)                );
                  // Are we playing something?
_dat_(            test    _lbl_(playing), _lbl_(playing)    wz        );
                  //  No:  Go decay frqa for shutdown.
_dat_(  if_z      jmp     #_lbl_(Dequeue_decay)                       );
                  //  Yes: Get the queue pointers.
_dat_(            rdword  _lbl_(enq_ptr), _lbl_(enq_ptr_addr)         );
_dat_(            rdword  _lbl_(deq_ptr), _lbl_(deq_ptr_addr)         );
                  //       Is the queue empty?
_dat_(            cmp     _lbl_(enq_ptr), _lbl_(deq_ptr)    wz        );
                  //         No:  Go get some data.
_dat_(  if_nz     jmp     #_lbl_(Dequeue_get_it)                      );
_dat_(  Dequeue_decay:                                                );
                  // Decay the output while waiting,
_dat_(            cmpsub  frqa, #$1ff    wc                           );
                  //  until it can be turned off without popping.
_dat_(  if_nc     andn    dira, _lbl_(tdira0)                         );
                  // Reinitialize ttime, so it's always current.
_dat_(            mov     _lbl_(ttime), cnt                           );
_dat_(            add     _lbl_(ttime), _lbl_(dttime)                 );
                  // Go check for a new command or data.
_dat_(            jmp     #_lbl_(dequeue)                             );
_dat_(  Dequeue_get_it:                                               );
_dat_(            shl     _lbl_(deq_ptr), #1                          );
                  // Convert deq_ptr to an address.
_dat_(            add     _lbl_(deq_ptr), _lbl_(queue_addr)           );
                  // Get the data at the address.
_dat_(            rdword  _lbl_(tacc), _lbl_(deq_ptr)                 );
                  // Convert deq_ptr back to an index.
_dat_(            sub     _lbl_(deq_ptr), _lbl_(queue_addr)           );
_dat_(            shr     _lbl_(deq_ptr), #1                          );
                  // Bump the pointer by one word.
_dat_(            add     _lbl_(deq_ptr), #1                          );
                  // Return pointer to zero if over the end.
_dat_(            cmpsub  _lbl_(deq_ptr), _lbl_(queue_size)           );
                  // Write the deq pointer back to hub.
_dat_(            wrword  _lbl_(deq_ptr), _lbl_(deq_ptr_addr)         );
_dat_(  dequeue_ret:                                                  );
                  // Return with new data.
_dat_(            ret                                                 );
_dat_(  fmult:                                                        );
                  // -------[ Fixed point multiply. ]----------------------------------------------
                  //    32 x 16.16 fixed-point unsigned multiply.
                  //    in:      tacc = 32-bit integer multiplicand
                  //             taccx = 32-bit fixed-point multiplier
                  //    out:     tacc = 32-bit product
                  // Initialize high long of product.
_dat_(            mov     _lbl_(t0), #0                               );
                  // Need 32 adds and shifts.
_dat_(            mov     _lbl_(t1), #$20                             );
                  // Seed the first carry.
_dat_(            shr     _lbl_(tacc), #1    wc                       );
_dat_(  Fmult_loop:                                                   );
                  // If multiplier was a one bit, add multiplicand.
_dat_(  if_c      add     _lbl_(t0), _lbl_(taccx)    wc               );
                  // Shift carry and 64-bit product right.
_dat_(            rcr     _lbl_(t0), #1    wc                         );
_dat_(            rcr     _lbl_(tacc), #1    wc                       );
                  // Back for another bit.
_dat_(            djnz    _lbl_(t1), #_lbl_(Fmult_loop)               );
                  // Fractional product is middle 32 bits of the 64.
_dat_(            shr     _lbl_(tacc), #$10                           );
_dat_(            shl     _lbl_(t0), #$10                             );
_dat_(            or      _lbl_(tacc), _lbl_(t0)                      );
_dat_(  fmult_ret:                                                    );
_dat_(            ret                                                 );
_dat_(  dttime:                                                       );
                  // -------[ Constants and hub-assigned parameters ]------------------------------
_dat_(            .long   (0 - 0)                                     );
_dat_(  queue_addr:                                                   );
_dat_(            .long   (0 - 0)                                     );
_dat_(  tctra0:                                                       );
_dat_(            .long   ((6 << $1a) | SCRIBBLER_SPEAKER)            );
_dat_(  tdira0:                                                       );
_dat_(            .long   (1 << SCRIBBLER_SPEAKER)                    );
_dat_(  zero:                                                         );
_dat_(            .long   0                                           );
_dat_(  amp0:                                                         );
_dat_(            .long   $80000000                                   );
_dat_(  maxamp:                                                       );
_dat_(            .long   $3fffffff                                   );
_dat_(  data_bits:                                                    );
_dat_(            .long   $1fff                                       );
_dat_(  _0x1000:                                                      );
_dat_(            .long   $1000                                       );
_dat_(  _0x0800:                                                      );
_dat_(            .long   $800                                        );
_dat_(  _0x7000:                                                      );
_dat_(            .long   $7000                                       );
_dat_(  volume:                                                       );
_dat_(            .long   $8000                                       );
_dat_(  playing:                                                      );
_dat_(            .long   0                                           );
_dat_(  queue_size:                                                   );
_dat_(            .long   SCRIBBLER__TONE_Q_SIZE                      );
_dat_(  enq_ptr_addr:                                                 );
                  // -------[ Variables ]----------------------------------------------------------
_dat_(            .res    1                                           );
_dat_(  deq_ptr_addr:                                                 );
_dat_(            .res    1                                           );
_dat_(  cmd_addr:                                                     );
_dat_(            .res    1                                           );
_dat_(  sync_addr:                                                    );
_dat_(            .res    1                                           );
_dat_(  enq_ptr:                                                      );
_dat_(            .res    1                                           );
_dat_(  deq_ptr:                                                      );
_dat_(            .res    1                                           );
_dat_(  phase1:                                                       );
_dat_(            .res    1                                           );
_dat_(  phase2:                                                       );
_dat_(            .res    1                                           );
_dat_(  phase:                                                        );
_dat_(            .res    1                                           );
_dat_(  freq1:                                                        );
_dat_(            .res    1                                           );
_dat_(  freq2:                                                        );
_dat_(            .res    1                                           );
_dat_(  voice1:                                                       );
_dat_(            .res    1                                           );
_dat_(  voice2:                                                       );
_dat_(            .res    1                                           );
_dat_(  voice:                                                        );
_dat_(            .res    1                                           );
_dat_(  duration:                                                     );
_dat_(            .res    1                                           );
_dat_(  ttime:                                                        );
_dat_(            .res    1                                           );
_dat_(  amp:                                                          );
_dat_(            .res    1                                           );
_dat_(  cmd:                                                          );
_dat_(            .res    1                                           );
_dat_(  tacc:                                                         );
_dat_(            .res    1                                           );
_dat_(  taccx:                                                        );
_dat_(            .res    1                                           );
_dat_(  t0:                                                           );
_dat_(            .res    1                                           );
_dat_(  t1:                                                           );
_dat_(            .res    1                                           );
_dat_(            .fit    $1f0                                        );
                  // -------[ Analog, Button, LED ]-----------------------------------------------                            

#undef _org_
#define _org_ ..org0003
_dat_(..org0003_base = . + 0x0                                        );
_dat_(  adc_all:                                                      );
                  // Initialize counter for ADC.
_dat_(            mov     ctra, _lbl_(ctra0)                          );
                  // Set mux pins and feedback to outputs.
_dat_(            mov     dira, _lbl_(dira0)                          );
_dat_(            mov     frqa, #1                                    );
_dat_(  Adc_all_ee_setup:                                             );
                  // -------[ EEPROM Adressing Setup ]--------------------------------------------   
                  // Copy the shifted model number into acc
_dat_(            mov     _lbl_(acc), par                             );
                  // Shift acc right to recover the model number                                                                         
_dat_(            shr     _lbl_(acc), #2                              );
                  // Jump if the model number isn't 0 (S2)
_dat_(            tjnz    _lbl_(acc), #_lbl_(Adc_all_ee_setup_s3)     );
                  // Set the S2 slave address command 
_dat_(            mov     _lbl_(ee_addr_cmd), #$a2                    );
                  // Set the S2 EEPROM user memory offsett
_dat_(            mov     _lbl_(ee_offset), _lbl_(s2_ee_offset)       );
_dat_(            jmp     #_lbl_(Adc_all_cal_start)                   );
_dat_(  Adc_all_ee_setup_s3:                                          );
                  // Set the S3 slave addres command
_dat_(            mov     _lbl_(ee_addr_cmd), #$a0                    );
                  // Set the S3 EEPROM user memory offsett 
_dat_(            mov     _lbl_(ee_offset), _lbl_(s3_ee_offset)       );
_dat_(  Adc_all_cal_start:                                            );
                  // -------[ Calibrate ADC for 3.3V and 5V full-scale. ]--------------------------
                  // Initialize pointers for VDD calibration.
_dat_(            movd    _lbl_(Adc_all_got_it), #(_lbl_(intvl3)/4)   );
_dat_(            movd    (_lbl_(Adc_all_got_it) + 4), #(_lbl_(loresult3)/4));
_dat_(            movs    _lbl_(Adc_all_set_mux), #SCRIBBLER__MUX_VDD );
_dat_(            mov     _lbl_(count), #2                            );
_dat_(            mov     _lbl_(soak_time), _lbl_(one_ms)             );
_dat_(  Adc_all_calibrate:                                            );
                  // Initialize sample interval to high value.
_dat_(            mov     _lbl_(intvl), _lbl_(intvl0)                 );
                  // Set delta interval to half that (binary search).
_dat_(            mov     _lbl_(dintvl), _lbl_(intvl0)                );
_dat_(            shr     _lbl_(dintvl), #1                           );
_dat_(  Adc_all_searchlp:                                             );
                  // Set mux to input Vss.
_dat_(            mov     _lbl_(mux_addr), #SCRIBBLER__MUX_VSS        );
                  // Read the value.
_dat_(            jmpret  _lbl_(adc_ret), #_lbl_(adc)                 );
                  // Save it.
_dat_(            mov     _lbl_(loresult), _lbl_(acc)                 );
_dat_(  Adc_all_set_mux:                                              );
                  // Set mux to read voltage input.
_dat_(            mov     _lbl_(mux_addr), #(0 - 0)                   );
                  // Read the value.
_dat_(            jmpret  _lbl_(adc_ret), #_lbl_(adc)                 );
                  // Subtract the zero result.
_dat_(            sub     _lbl_(acc), _lbl_(loresult)                 );
                  // Does net result equal 255?
_dat_(            cmps    _lbl_(acc), #$ff    wz, wc                  );
                  //  Yes: Perfect. We're done.  
_dat_(  if_z      jmp     #_lbl_(Adc_all_got_it)                      );
                  //  No:  Adjust interval accordingly.
_dat_(            sumnc   _lbl_(intvl), _lbl_(dintvl)                 );
                  //       Cut delta in half. Equal to zero?
_dat_(            shr     _lbl_(dintvl), #1    wz                     );
                  //         No:  Do another search iteration.
_dat_(  if_nz     jmp     #_lbl_(Adc_all_searchlp)                    );
_dat_(  Adc_all_got_it:                                               );
                  // Found 255 or delta == 0. Save calibration.
_dat_(            mov     (0 - 0), _lbl_(intvl)                       );
_dat_(            mov     (0 - 0), _lbl_(loresult)                    );
                  // Now set up to calibrate for 5V full-scale.
_dat_(            movd    _lbl_(Adc_all_got_it), #(_lbl_(intvl5)/4)   );
_dat_(            movd    (_lbl_(Adc_all_got_it) + 4), #(_lbl_(loresult5)/4));
_dat_(            movs    _lbl_(Adc_all_set_mux), #SCRIBBLER__MUX_5V  );
                  // Go back and do 5V if not done.
_dat_(            djnz    _lbl_(count), #_lbl_(Adc_all_calibrate)     );
                  // -------[ Main program loop: cycle through and record all ADC inputs. ]--------
                  // Initialize the loop timer.
_dat_(            mov     _lbl_(loop_timer), cnt                      );
                  // Executes onece per millisecond.
_dat_(            add     _lbl_(loop_timer), _lbl_(one_ms)            );
_dat_(  main_lp:                                                      );
                  // Wait for next 1ms interval.
_dat_(            waitcnt _lbl_(loop_timer), _lbl_(one_ms)            );
                  // Update timer.
_dat_(            mov     _lbl_(results_ptr), _lbl_(results_addr)     );
_dat_(            add     _lbl_(results_ptr), #(SCRIBBLER_TIMER * 2)  );
_dat_(            rdlong  _lbl_(acc), _lbl_(results_ptr)              );
_dat_(            add     _lbl_(acc), #1                              );
_dat_(            wrlong  _lbl_(acc), _lbl_(results_ptr)              );
                  // Set sequence pointer to sequence beginning.
_dat_(            mov     _lbl_(seq_ptr), _lbl_(seq_addr)             );
                  // Increment the loop counter.
_dat_(            add     _lbl_(loop_ctr), #1                         );
_dat_(  Main_lp_sample_lp:                                            );
                  // Read next command from sequence.
_dat_(            rdword  _lbl_(acc), _lbl_(seq_ptr)    wz            );
                  // End of sequence if zero. Go do other stuff.
_dat_(  if_z      jmp     #_lbl_(Main_lp_do_button)                   );
                  // Bump sequence pointer to next word.
_dat_(            add     _lbl_(seq_ptr), #2                          );
                  // Unpack the MUX address for this sample.
_dat_(            mov     _lbl_(mux_addr), _lbl_(acc)                 );
_dat_(            shr     _lbl_(mux_addr), #$c                        );
                  // Unpack the Results index.
_dat_(            mov     _lbl_(results_ptr), _lbl_(acc)              );
_dat_(            shr     _lbl_(results_ptr), #7                      );
_dat_(            and     _lbl_(results_ptr), #$1e                    );
_dat_(            add     _lbl_(results_ptr), _lbl_(results_addr)     );
                  // Unpack and compute soak time.
_dat_(            mov     _lbl_(count), _lbl_(acc)                    );
_dat_(            shr     _lbl_(count), #4                            );
_dat_(            and     _lbl_(count), #$f                           );
_dat_(            mov     _lbl_(soak_time), #$50                      );
_dat_(            shl     _lbl_(soak_time), _lbl_(count)              );
                  // Unpack and compute filter value.
_dat_(            mov     _lbl_(filter), _lbl_(acc)                   );
_dat_(            shr     _lbl_(filter), #1                           );
_dat_(            and     _lbl_(filter), #7                           );
                  // Sample the input and do ADC.
_dat_(            jmpret  _lbl_(do_adc_ret), #_lbl_(do_adc)           );
                  // Is this the idler wheel?
_dat_(            cmp     _lbl_(mux_addr), #SCRIBBLER__MUX_IDLER    wz);
                  //  No:  Skip next section.
_dat_(  if_nz     jmp     #_lbl_(Main_lp_not_idler)                   );
                  //  Yes: Save the unilluminated value.
_dat_(            mov     _lbl_(accx), _lbl_(acc)                     );
                  //       Turn on the IRED
_dat_(            or      outa, _lbl_(idler_on)                       );
                  //       Make sure to reference to 3.3V again.
_dat_(            andn    _lbl_(acc), #1                              );
                  //       Get the value with IRED on.
_dat_(            jmpret  _lbl_(do_adc_ret), #_lbl_(do_adc)           );
                  //       Turn off IRED.
_dat_(            andn    outa, _lbl_(idler_on)                       );
                  //       Subtract unilluminated value.
_dat_(            sub     _lbl_(acc), _lbl_(accx)                     );
                  //       Make sure result is not negative.
_dat_(            mins    _lbl_(acc), #0                              );
_dat_(  Main_lp_not_idler:                                            );
                  // Get the current value of the result.
_dat_(            rdword  _lbl_(count), _lbl_(results_ptr)            );
                  // Transfer to temp accx.
_dat_(            mov     _lbl_(accx), _lbl_(count)                   );
                  // Shift it right by filter amount.
_dat_(            shr     _lbl_(accx), _lbl_(filter)                  );
                  // Subtract shifted value form current value.
_dat_(            sub     _lbl_(count), _lbl_(accx)                   );
                  // Get new value into upper byte.
_dat_(            shl     _lbl_(acc), #8                              );
                  // Shift it right by filter amount.
_dat_(            shr     _lbl_(acc), _lbl_(filter)                   );
                  // Add to create new value.
_dat_(            add     _lbl_(count), _lbl_(acc)                    );
                  // Save new value back to array.
_dat_(            wrword  _lbl_(count), _lbl_(results_ptr)            );
                  // Processing the idler wheel?
_dat_(  if_nz     jmp     #_lbl_(Main_lp_sample_lp)                   );
                  //  Yes: Make idler value byte-sized.
_dat_(            shr     _lbl_(count), #8                            );
                  //       Is current idler state high?
_dat_(            test    _lbl_(idler_state), #1    wz                );
                  //         Yes: Use lower threshold.
_dat_(  if_nz     mov     _lbl_(acc), #$a                             );
                  //         No:  Use upper threshold.
_dat_(  if_z      mov     _lbl_(acc), #$f                             );
                  //       Set carry if value is lower than threshold.
_dat_(            cmp     _lbl_(count), _lbl_(acc)    wc              );
                  //       Set current idler state based on comparison.
_dat_(            muxnc   _lbl_(idler_state), #1                      );
                  //       Done unless was low and went high or was high and went low.
_dat_(  if_z_eq_c jmp     #_lbl_(Main_lp_sample_lp)                   );
                  //       Point to idler count result.
_dat_(            mov     _lbl_(results_ptr), _lbl_(results_addr)     );
_dat_(            add     _lbl_(results_ptr), #(SCRIBBLER_CNT_IDLER * 2));
                  //       Read the current count.
_dat_(            rdword  _lbl_(count), _lbl_(results_ptr)            );
                  //       Bump it.
_dat_(            add     _lbl_(count), #1                            );
                  //       Write it back.
_dat_(            wrword  _lbl_(count), _lbl_(results_ptr)            );
                  //       Done with idler.
_dat_(            jmp     #_lbl_(Main_lp_sample_lp)                   );
_dat_(  Main_lp_do_button:                                            );
                  // Point to button flags.
_dat_(            mov     _lbl_(results_ptr), _lbl_(results_addr)     );
_dat_(            add     _lbl_(results_ptr), #((SCRIBBLER_BUTTON_CNT * 2) + 1));
                  // Get them.
_dat_(            rdbyte  _lbl_(btn_flgs), _lbl_(results_ptr)         );
                  // Get state of button input into carry.
_dat_(            test    _lbl_(btn_mask), ina    wc                  );
                  // Reset timer if button is down.
_dat_(  if_nc     mov     _lbl_(btn_timer), _lbl_(one_second)         );
                  // Shift into debounce register. Z set if down => 32ms.
_dat_(            rcl     _lbl_(btn_shift), #1    wz                  );
                  // Was debounced button down last time.
_dat_(            test    _lbl_(btn_cnt), #1    wc                    );
                  //  Yes: Z set if up => 32ms. 
_dat_(  if_c      add     _lbl_(btn_shift), #1    wz, nr              );
                  // Increment count if debounced change of state.
_dat_(  if_z      add     _lbl_(btn_cnt), #1                          );
                  // Get actual button count in acc,
_dat_(            mov     _lbl_(accx), _lbl_(btn_cnt)                 );
                  //  stripped of flag bits.
_dat_(            shr     _lbl_(accx), #1    wz                       );
                  // Saturate button count to 8.
_dat_(            max     _lbl_(accx), #8                             );
                  // Decrement end-of-cluster timer. Was zero?
_dat_(            cmpsub  _lbl_(btn_timer), #1    wc                  );
                  //  No:  Jump around.
_dat_(  if_z_or_c jmp     #_lbl_(Main_lp_do_leds)                     );
                  //  Yes: Point to button count in Results array.
_dat_(            sub     _lbl_(results_ptr), #1                      );
                  //       Write the value.
_dat_(            wrbyte  _lbl_(accx), _lbl_(results_ptr)             );
                  //       Clear count.
_dat_(            mov     _lbl_(btn_cnt), #0                          );
                  // Is reset-on-button enabled?
_dat_(            test    _lbl_(btn_flgs), #SCRIBBLER_RST_ENA    wc   );
                  //  No:  Skip to the LED stuff.
_dat_(  if_nc     jmp     #_lbl_(Main_lp_do_leds)                     );
                  // Who am I? (Need to stop every cog but me.)
_dat_(            cogid   _lbl_(acc)                                  );
                  // Eight cogs to go.
_dat_(            mov     _lbl_(count), #7                            );
_dat_(  Main_lp_stop_cogs:                                            );
                  // Is this me?
_dat_(            cmp     _lbl_(acc), _lbl_(count)    wz              );
                  //  No:  Stop the cog.
_dat_(  if_nz     cogstop _lbl_(count)                                );
_dat_(            sub     _lbl_(count), #1    wc                      );
_dat_(  if_nc     jmp     #_lbl_(Main_lp_stop_cogs)                   );
                  // Save button count to aux EEPROM.
_dat_(            mov     _lbl_(ee_addr), #SCRIBBLER_EE_RESET_CNT     );
                  // Send the address.
_dat_(            jmpret  _lbl_(i2c_waddr_ret), #_lbl_(i2c_waddr)     );
                  // Get the data.
_dat_(            mov     _lbl_(acc), _lbl_(accx)                     );
                  // Send that, too.
_dat_(            jmpret  _lbl_(i2c_wr_ret), #_lbl_(i2c_wr)           );
                  // Stop the transfer and finish the write.
_dat_(            jmpret  _lbl_(i2c_stop_ret), #_lbl_(i2c_stop)       );
                  // Turn off all the LEDs.
_dat_(            mov     _lbl_(dintvl), #0                           );
_dat_(            jmpret  _lbl_(show_leds_ret), #_lbl_(show_leds)     );
                  // Reset the Prop.
_dat_(            clkset  _lbl_(reeboot)                              );
_dat_(  Main_lp_do_leds:                                              );
                  // Are LEDs enabled for tracking button presses?
_dat_(            test    _lbl_(btn_flgs), #SCRIBBLER_LED_ENA    wc   );
                  // If not, or if button count is zero, skip around.
_dat_(  if_z_or_nc jmp     #_lbl_(Main_lp_reg_led)                    );
                  // Get the LED shift sequence in accx.
_dat_(            mov     _lbl_(acc), _lbl_(led_seq)                  );
                  // Shift right by button count, times two.
_dat_(            shr     _lbl_(acc), _lbl_(accx)                     );
_dat_(            shr     _lbl_(acc), _lbl_(accx)                     );
                  // Initialize the LED shift register to zero.
_dat_(            mov     _lbl_(dintvl), #0                           );
                  // Three LEDs x 2 pins per LED.
_dat_(            mov     _lbl_(count), #6                            );
                  // Start with left-hand LED.
_dat_(            mov     _lbl_(intvl), #$10                          );
_dat_(  Main_lp_led_seq_lp:                                           );
                  // Get the next bit.
_dat_(            shr     _lbl_(acc), #1    wc                        );
                  // Insert it into the shift register.
_dat_(            muxc    _lbl_(dintvl), _lbl_(intvl)                 );
                  // Rolling over from Left = $20 to Center = %01
_dat_(            test    _lbl_(intvl), #$20    wc                    );
_dat_(            and     _lbl_(intvl), #$1f                          );
_dat_(            rcl     _lbl_(intvl), #1                            );
                  // Back for next bit.         
_dat_(            djnz    _lbl_(count), #_lbl_(Main_lp_led_seq_lp)    );
                  // Want power LED to flash if reset is enabled.
_dat_(            test    _lbl_(loop_ctr), #$40    wc                 );
                  // Is it enabled?
_dat_(            test    _lbl_(btn_flgs), #SCRIBBLER_RST_ENA    wz   );
                  //  Yes: Insert bit for pwoer LED.
_dat_(  if_nz     muxc    _lbl_(dintvl), #$80                         );
                  // It's showtime! 
_dat_(            jmp     #_lbl_(Main_lp_show_leds)                   );
_dat_(  Main_lp_reg_led:                                              );
                  // Point to LED bytes in Results array.
_dat_(            mov     _lbl_(results_ptr), _lbl_(results_addr)     );
_dat_(            add     _lbl_(results_ptr), #(SCRIBBLER_LED_BYTES * 2));
                  // Four LEDs to do.
_dat_(            mov     _lbl_(count), #4                            );
                  // Last four bits of loop_ctr for PWM.
_dat_(            mov     _lbl_(intvl), _lbl_(loop_ctr)               );
_dat_(            and     _lbl_(intvl), #$f                           );
_dat_(            add     _lbl_(intvl), #1                            );
_dat_(  Main_lp_led_lp:                                               );
                  // Get the LED byte.
_dat_(            rdbyte  _lbl_(acc), _lbl_(results_ptr)              );
                  // Increment pointer.
_dat_(            add     _lbl_(results_ptr), #1                      );
                  // Red is accx.
_dat_(            mov     _lbl_(accx), _lbl_(acc)                     );
_dat_(            shr     _lbl_(accx), #4                             );
                  // Green is acc.
_dat_(            and     _lbl_(acc), #$f                             );
                  // Get the total PWM time.
_dat_(            mov     _lbl_(soak_time), _lbl_(acc)                );
_dat_(            add     _lbl_(soak_time), _lbl_(accx)               );
                  // Is total greater than 15?
_dat_(            cmp     _lbl_(soak_time), #$10    wc                );
                  //  Yes: Alternate color is red? Or green?
_dat_(  if_nc     test    _lbl_(loop_ctr), #$100    wz                );
                  //         Red:   Zero out green.
_dat_(  if_nc_and_z mov     _lbl_(acc), #0                            );
                  //         Green: Zero out red.
_dat_(  if_nc_and_nz mov     _lbl_(accx), #0                          );
                  // Map 1->0 so flashing works without stray color.
_dat_(            cmp     _lbl_(acc), #1    wz                        );
_dat_(  if_z      mov     _lbl_(acc), #0                              );
_dat_(            cmp     _lbl_(accx), #1    wz                       );
_dat_(  if_z      mov     _lbl_(accx), #0                             );
                  // Compute total PWM time again.
_dat_(            mov     _lbl_(soak_time), _lbl_(acc)                );
_dat_(            add     _lbl_(soak_time), _lbl_(accx)               );
                  // Shift %00 into register slot for this color.
_dat_(            shl     _lbl_(dintvl), #2                           );
                  // Is total PWM for this LED => PWM interval?
_dat_(            cmp     _lbl_(soak_time), _lbl_(intvl)    wc        );
                  //  No:  LED is off for this time slot.
_dat_(  if_c      jmp     #_lbl_(Main_lp_next_led)                    );
                  //  Yes: Is green PWM for this LED => PWM interval?
_dat_(            cmp     _lbl_(acc), _lbl_(intvl)    wc              );
                  //         Yes: Set green color.         
_dat_(  if_nc     or      _lbl_(dintvl), #1                           );
                  //         No:  Set red color.
_dat_(  if_c      or      _lbl_(dintvl), #2                           );
_dat_(  Main_lp_next_led:                                             );
                  // Go back for next LED.
_dat_(            djnz    _lbl_(count), #_lbl_(Main_lp_led_lp)        );
_dat_(  Main_lp_show_leds:                                            );
_dat_(            jmpret  _lbl_(show_leds_ret), #_lbl_(show_leds)     );
_dat_(            jmp     #_lbl_(main_lp)                             );
_dat_(  show_leds:                                                    );
                  // -------[ Clock out the LED data in dintvl. ]----------------------------------
                  // Eight bits to shift.
_dat_(            mov     _lbl_(count), #8                            );
_dat_(  Show_leds_send_lp:                                            );
                  // Get next bit in carry.
_dat_(            shr     _lbl_(dintvl), #1    wc                     );
                  // Put it on data line.
_dat_(            muxc    outa, #(1 << SCRIBBLER_LED_DATA)            );
                  // Pulse the clock.
_dat_(            or      outa, #(1 << SCRIBBLER_LED_CLK)             );
_dat_(            andn    outa, #(1 << SCRIBBLER_LED_CLK)             );
                  // Back for next bit.
_dat_(            djnz    _lbl_(count), #_lbl_(Show_leds_send_lp)     );
                  // Force data low to avoid power light on reset.
_dat_(            andn    outa, #(1 << SCRIBBLER_LED_DATA)            );
_dat_(  show_leds_ret:                                                );
_dat_(            ret                                                 );
_dat_(  do_adc:                                                       );
                  // -------[ Complete ADC routine: applies calibration data. ]--------------------
                  // Test it: is it a one?
_dat_(            test    _lbl_(acc), #1    wc                        );
                  //  No:  Set up for 3.3V full-scale.
_dat_(  if_nc     mov     _lbl_(loresult), _lbl_(loresult3)           );
_dat_(  if_nc     mov     _lbl_(intvl), _lbl_(intvl3)                 );
                  //  Yes: Set up for 5V full-scale.
_dat_(  if_c      mov     _lbl_(loresult), _lbl_(loresult5)           );
_dat_(  if_c      mov     _lbl_(intvl), _lbl_(intvl5)                 );
                  // Set carry to enable post-processing.
_dat_(            test    (. - ..org0003), #1    wc                   );
                  // Go do the work.
_dat_(            jmp     #_lbl_(_adc)                                );
_dat_(  adc:                                                          );
                  // -------[ Basic ADC routine. ]-------------------------------------------------
                  // Clear carry to skip post processing.
_dat_(            test    (. - ..org0003), #0    wc                   );
_dat_(  _adc:                                                         );
                  // Steer mux address to proper bit position.
_dat_(            shl     _lbl_(mux_addr), #SCRIBBLER_MUX0            );
                  // Read the output buffer.
_dat_(            mov     _lbl_(acc), outa                            );
                  // Zap the old mux address.
_dat_(            andn    _lbl_(acc), _lbl_(mux_mask)                 );
                  // Insert the new one.
_dat_(            or      _lbl_(acc), _lbl_(mux_addr)                 );
                  // Write it to the mux pins.
_dat_(            mov     outa, _lbl_(acc)                            );
                  // Restore the mux address.
_dat_(            shr     _lbl_(mux_addr), #SCRIBBLER_MUX0            );
                  // Read the count register.
_dat_(            mov     _lbl_(adc_timer), cnt                       );
                  // Bump it a little for the wait.
_dat_(            add     _lbl_(adc_timer), _lbl_(soak_time)          );
                  // Synchronize the read of phsa to waitcnt.
_dat_(            waitcnt _lbl_(adc_timer), _lbl_(intvl)              );
                  // Read phsa and negate it into acc.
_dat_(            neg     _lbl_(acc), phsa                            );
                  // Wait for the calibrated time interval.
_dat_(            waitcnt _lbl_(adc_timer), #0                        );
                  // Add the new result to get a delta value.
_dat_(            add     _lbl_(acc), phsa                            );
                  // Post-processing?        
                  //  Yes: Subtract the zero reference.            
_dat_(  if_c      sub     _lbl_(acc), _lbl_(loresult)                 );
                  //       Make sure result is between 0
_dat_(  if_c      mins    _lbl_(acc), #0                              );
                  //         and 255.
_dat_(  if_c      maxs    _lbl_(acc), #$ff                            );
_dat_(  adc_ret:                                                      );
_dat_(  do_adc_ret:                                                   );
                  // Return to caller.
_dat_(            ret                                                 );
_dat_(  i2c_waddr:                                                    );
                  // -----------[ i2c routines ]--------------------------------------------------
                  // i2c_waddr: Write address in ee_addr to aux eeprom.
                  // Add the memory address offsett 
_dat_(            add     _lbl_(ee_addr), _lbl_(ee_offset)            );
                  // Do start condition.
_dat_(            jmpret  _lbl_(i2c_start_ret), #_lbl_(i2c_start)     );
                  // Set write address command in acc.
_dat_(            mov     _lbl_(acc), _lbl_(ee_addr_cmd)              );
                  // Send it.
_dat_(            jmpret  _lbl_(i2c_wr_ret), #_lbl_(i2c_wr)           );
                  // Restart if not acknowledged (may be busy writing a page).
_dat_(  if_c      jmp     #_lbl_(i2c_waddr)                           );
                  // Get high byte of address.
_dat_(            mov     _lbl_(acc), _lbl_(ee_addr)                  );
_dat_(            shr     _lbl_(acc), #8                              );
                  // Send it.
_dat_(            jmpret  _lbl_(i2c_wr_ret), #_lbl_(i2c_wr)           );
                  // Get low byte of address.
_dat_(            mov     _lbl_(acc), _lbl_(ee_addr)                  );
                  // Send it.
_dat_(            jmpret  _lbl_(i2c_wr_ret), #_lbl_(i2c_wr)           );
_dat_(  i2c_waddr_ret:                                                );
                  // Over and out.
_dat_(            ret                                                 );
_dat_(  i2c_rd_nak:                                                   );
                  // i2c_rd_nak: Read a byte from eeprom and send NAK.
                  // Set carry flag (odd parity) for NAK.
_dat_(            test    (. - ..org0003), #1    wc                   );
_dat_(            jmp     #_lbl_(i2c_rd)                              );
_dat_(  i2c_rd_ack:                                                   );
                  // i2c_rd_ack: Read a byte from eeprom and send ACK.
                  // Clear carry flag (even parity) for ACK.
_dat_(            test    (. - ..org0003), #0    wc                   );
_dat_(  i2c_rd:                                                       );
                  // i2c_rd: Read a byte from eeprom and send ACK/NAK based on carry.
                  // Make sure no zeroes get written.
_dat_(            mov     _lbl_(acc), #$ff                            );
_dat_(            jmp     #_lbl_(i2c_rd_wr)                           );
_dat_(  i2c_wr:                                                       );
                  // i2c_wr: Write a byte to eeprom, returning ACK in carry.
                  // Set carry flag (odd parity) to read ACK.
_dat_(            test    (. - ..org0003), #1    wc                   );
_dat_(  i2c_rd_wr:                                                    );
                  // i2c_byte: Combo read and write byte routine.
                  // Nine bits, including ACK.
_dat_(            mov     _lbl_(count), #9                            );
                  // Get byte into 8 MSBs, and ACK/NAK into next bit.
_dat_(            rcl     _lbl_(acc), #$18                            );
_dat_(  I2c_rd_wr_wrlp:                                               );
                  // Rotate carry into acc and next write bit out.
_dat_(            rcl     _lbl_(acc), #1    wc                        );
                  // Pull sda low iff carry is clear.
_dat_(            muxnc   dira, _lbl_(sda_pin)                        );
                  // Wait 650ns.
_dat_(            jmpret  _lbl_(delay650_ret), #_lbl_(delay650)       );
                  // Drive SCL high.
_dat_(            or      outa, _lbl_(scl_pin)                        );
                  // Wait 650ns.
_dat_(            jmpret  _lbl_(delay650_ret), #_lbl_(delay650)       );
                  // Get sda pin state into carry (parity). (Last time is ACK/NAK.)
_dat_(            test    _lbl_(sda_pin), ina    wc                   );
                  // Drive SCL low.
_dat_(            andn    outa, _lbl_(scl_pin)                        );
                  // Wait 650ns.
_dat_(            jmpret  _lbl_(delay650_ret), #_lbl_(delay650)       );
                  // Back for next bit.
_dat_(            djnz    _lbl_(count), #_lbl_(I2c_rd_wr_wrlp)        );
                  // Acc has data read from i2c; carry has ACK/NAK.
_dat_(            and     _lbl_(acc), #$ff                            );
_dat_(  i2c_rd_ack_ret:                                               );
_dat_(  i2c_rd_nak_ret:                                               );
_dat_(  i2c_rd_ret:                                                   );
_dat_(  i2c_wr_ret:                                                   );
_dat_(            ret                                                 );
_dat_(  i2c_start:                                                    );
                  // i2c_start: Set a start condition.
                  // Let sda float high.
_dat_(            andn    dira, _lbl_(sda_pin)                        );
                  // Wait 650ns.
_dat_(            jmpret  _lbl_(delay650_ret), #_lbl_(delay650)       );
                  // Drive SCL high.
_dat_(            or      outa, _lbl_(scl_pin)                        );
_dat_(            or      dira, _lbl_(scl_pin)                        );
                  // Wait 650ns.
_dat_(            jmpret  _lbl_(delay650_ret), #_lbl_(delay650)       );
                  // Pull sda low.
_dat_(            or      dira, _lbl_(sda_pin)                        );
                  // Wait 650ns.
_dat_(            jmpret  _lbl_(delay650_ret), #_lbl_(delay650)       );
                  // Drive SCL low.
_dat_(            andn    outa, _lbl_(scl_pin)                        );
                  // Wait 650ns.
_dat_(            jmpret  _lbl_(delay650_ret), #_lbl_(delay650)       );
_dat_(  i2c_start_ret:                                                );
_dat_(            ret                                                 );
_dat_(  i2c_stop:                                                     );
                  // i2c_stop: Set a stop condition.
                  // Pull SCL low.
_dat_(            andn    outa, _lbl_(scl_pin)                        );
                  // Wait 650ns.
_dat_(            jmpret  _lbl_(delay650_ret), #_lbl_(delay650)       );
                  // Pull sda low.
_dat_(            or      dira, _lbl_(sda_pin)                        );
                  // Wait 650ns.
_dat_(            jmpret  _lbl_(delay650_ret), #_lbl_(delay650)       );
                  // Drive SCL high.
_dat_(            or      outa, _lbl_(scl_pin)                        );
                  // Wait 650ns.
_dat_(            jmpret  _lbl_(delay650_ret), #_lbl_(delay650)       );
                  // Let sda float high.
_dat_(            andn    dira, _lbl_(sda_pin)                        );
                  // Wait 650ns.
_dat_(            jmpret  _lbl_(delay650_ret), #_lbl_(delay650)       );
                  // Let SCL float.
_dat_(            andn    dira, _lbl_(scl_pin)                        );
_dat_(  i2c_stop_ret:                                                 );
_dat_(            ret                                                 );
_dat_(  delay650:                                                     );
                  // -------[ Delay routines. ]-----------------------------------------------------
                  // delay650: Wait 650 ns.
_dat_(            mov     _lbl_(adc_timer), #$34                      );
_dat_(            add     _lbl_(adc_timer), cnt                       );
_dat_(            waitcnt _lbl_(adc_timer), #0                        );
_dat_(  delay650_ret:                                                 );
_dat_(            ret                                                 );
_dat_(  ctra0:                                                        );
                  // -------[ Assembly constants and predefined variables. ]-----------------------
_dat_(            .long   (((9 << $1a) | (SCRIBBLER__MUX_ADC_OUT << 9)) | SCRIBBLER__MUX_ADC_IN));
_dat_(  dira0:                                                        );
_dat_(            .long   (((((1 << SCRIBBLER__MUX_ADC_OUT) | ($f << SCRIBBLER_MUX0)) | (1 << SCRIBBLER_IDLER_TX)) | (1 << SCRIBBLER_LED_DATA)) | (1 << SCRIBBLER_LED_CLK)));
                  // Mask for idler IRED.
_dat_(  idler_on:                                                     );
_dat_(            .long   (1 << SCRIBBLER_IDLER_TX)                   );
                  // Mask for multiplexer address bits.
_dat_(  mux_mask:                                                     );
_dat_(            .long   ($f << SCRIBBLER_MUX0)                      );
_dat_(  scl_pin:                                                      );
_dat_(            .long   (1 << SCRIBBLER_SCL)                        );
_dat_(  sda_pin:                                                      );
_dat_(            .long   (1 << SCRIBBLER_SDA)                        );
                  // Initial calibration interval.
_dat_(  intvl0:                                                       );
_dat_(            .long   $800                                        );
                  // Clock ticks for 1 ms at 80 MHz.
_dat_(  one_ms:                                                       );
_dat_(            .long   $13880                                      );
                  // Ticks for one second at 1 KHz.
_dat_(  one_second:                                                   );
_dat_(            .long   $3e8                                        );
                  // Used with clkset to reset the Prop chip.
_dat_(  reeboot:                                                      );
_dat_(            .long   $80                                         );
                  // Input mask for push button.
_dat_(  btn_mask:                                                     );
_dat_(            .long   (1 << SCRIBBLER_BUTTON)                     );
                  // Number of debounced button transitions.
_dat_(  btn_cnt:                                                      );
_dat_(            .long   0                                           );
                  // Shift register for debouncing.
_dat_(  btn_shift:                                                    );
_dat_(            .long   -1                                          );
                  // Countdown timer for last button press.
_dat_(  btn_timer:                                                    );
_dat_(            .long   0                                           );
                  // Current state of idler wheel.
_dat_(  idler_state:                                                  );
_dat_(            .long   0                                           );
                  // Points to beginning of Results array.
_dat_(  results_addr:                                                 );
_dat_(            .long   (0 - 0)                                     );
                  // Points to beginning of ADC sequence array.
_dat_(  seq_addr:                                                     );
_dat_(            .long   (0 - 0)                                     );
                  // LED sequence for button presses R->L.
_dat_(  led_seq:                                                      );
_dat_(            .long   $2a540                                      );
                  // EEPROM user memory address offset for the S2
_dat_(  s2_ee_offset:                                                 );
_dat_(            .long   0                                           );
                  // EEPROM user memory address offset for the S3                 
_dat_(  s3_ee_offset:                                                 );
_dat_(            .long   $8000                                       );
                  // Mux address: 0..15
_dat_(  mux_addr:                                                     );
                  // -------[ Assembly variables. ]------------------------------------------------
_dat_(            .res    1                                           );
                  // Points to current ADC command.                      
_dat_(  seq_ptr:                                                      );
_dat_(            .res    1                                           );
                  // Points into Results array.
_dat_(  results_ptr:                                                  );
_dat_(            .res    1                                           );
                  // Current soak time.
_dat_(  soak_time:                                                    );
_dat_(            .res    1                                           );
                  // Current filter value.
_dat_(  filter:                                                       );
_dat_(            .res    1                                           );
                  // Next cnt value for loop interval.
_dat_(  loop_timer:                                                   );
_dat_(            .res    1                                           );
                  // Timer for analog acquisition.
_dat_(  adc_timer:                                                    );
_dat_(            .res    1                                           );
                  // Zero reference (offset) for ADC.
_dat_(  loresult:                                                     );
_dat_(            .res    1                                           );
                  // Time interval for ADC.
_dat_(  intvl:                                                        );
_dat_(            .res    1                                           );
                  // Delta interval fro calibration.
_dat_(  dintvl:                                                       );
_dat_(            .res    1                                           );
                  // Offset for 3.3V full-scale.
_dat_(  loresult3:                                                    );
_dat_(            .res    1                                           );
                  // Time interval for 3.3V full-scale.
_dat_(  intvl3:                                                       );
_dat_(            .res    1                                           );
                  // Offset for 5V full-scale.
_dat_(  loresult5:                                                    );
_dat_(            .res    1                                           );
                  // Time interval for 5V full-scale.
_dat_(  intvl5:                                                       );
_dat_(            .res    1                                           );
                  // General-purpose accumulator.
_dat_(  acc:                                                          );
_dat_(            .res    1                                           );
                  // Another general-purpose register.
_dat_(  accx:                                                         );
_dat_(            .res    1                                           );
                  // General-purpose counter.
_dat_(  count:                                                        );
_dat_(            .res    1                                           );
                  // Loop counter.
_dat_(  loop_ctr:                                                     );
_dat_(            .res    1                                           );
                  // Flags that control button behavior.
_dat_(  btn_flgs:                                                     );
_dat_(            .res    1                                           );
                  // User EEPROM current memory address
_dat_(  ee_addr:                                                      );
_dat_(            .res    1                                           );
                  // User EEPROM memory start address
_dat_(  ee_offset:                                                    );
_dat_(            .res    1                                           );
                  // User EEPROM address command
_dat_(  ee_addr_cmd:                                                  );
_dat_(            .res    1                                           );
_dat_(            .fit    $1f0                                        );
                  // -------[ Motors ]------------------------------------------------------------

#undef _org_
#define _org_ ..org0004
_dat_(..org0004_base = . + 0x0                                        );
_dat_(  motor_driver:                                                 );
                  // Set dir and pwm pins to output.
_dat_(            mov     dira, _lbl_(mdira0)                         );
                  // Initialize PWM counter frequencies.
_dat_(            mov     frqa, #1                                    );
_dat_(            mov     frqb, #1                                    );
                  // Get the displacement parameter address.
_dat_(            mov     _lbl_(mpar_addr), par                       );
_dat_(            add     _lbl_(mpar_addr), #4                        );
                  // Get the status address.
_dat_(            mov     _lbl_(mstat_addr), par                      );
_dat_(            add     _lbl_(mstat_addr), #8                       );
                  // Initialize timer.
_dat_(            mov     _lbl_(mtime), cnt                           );
_dat_(            add     _lbl_(mtime), _lbl_(mdt)                    );
                  // Get right encoder input.
_dat_(            test    _lbl_(right_enc_bit), ina    wc             );
                  // Shift it into register.
_dat_(            rcl     _lbl_(right_enc), #1                        );
                  // Same for left encoder.
_dat_(            test    _lbl_(left_enc_bit), ina    wc              );
_dat_(            rcl     _lbl_(left_enc), #1                         );
                  // Zero the current PWM value.
_dat_(            mov     _lbl_(nominal_pwm), #0                      );
_dat_(            jmpret  _lbl_(clr_stat_ret), #_lbl_(clr_stat)       );
                  // Tell caller we're ready for a new command.
_dat_(            wrlong  _lbl_(mzero), par                           );
_dat_(  Motor_driver_main_lp:                                         );
                  // Is there a command waiting?
_dat_(            rdlong  _lbl_(mcmd), par    wz                      );
                  //  Yes: Go do it.
_dat_(  if_nz     jmp     #_lbl_(Motor_driver_do_cmd)                 );
_dat_(  Motor_driver_stop:                                            );
                  //  No:  Force stop. Turn off PWMs.
_dat_(            mov     ctra, #0                                    );
_dat_(            mov     ctrb, #0                                    );
                  //       Clear the velocity and idler status.
_dat_(            jmpret  _lbl_(clr_stat_ret), #_lbl_(clr_stat)       );
_dat_(  Motor_driver_chk_cmd:                                         );
                  // Get the next command. Is it non-zero?
_dat_(            rdlong  _lbl_(mcmd), par    wz                      );
                  //  No:  Try again.
_dat_(  if_z      jmp     #_lbl_(Motor_driver_chk_cmd)                );
_dat_(  Motor_driver_do_cmd:                                          );
                  // Get and isolate the timeout value.
_dat_(            mov     _lbl_(motor_timer), _lbl_(mcmd)             );
                  // Is it non-zero?
_dat_(            shr     _lbl_(motor_timer), #$10    wz              );
                  // Set timeout flag according to motor_timer <> 0
_dat_(  if_nz     muxnz   _lbl_(mcmd), #SCRIBBLER_MOT_TIMED           );
                  // Isolate the maximum velocity parameter.
_dat_(            mov     _lbl_(max_vel), _lbl_(mcmd)                 );
_dat_(            shr     _lbl_(max_vel), #8                          );
_dat_(            and     _lbl_(max_vel), #$f                         );
                  // Isolate the end velocity parameter.
_dat_(            mov     _lbl_(end_vel), _lbl_(mcmd)                 );
_dat_(            shr     _lbl_(end_vel), #4                          );
_dat_(            and     _lbl_(end_vel), #$f                         );
                  // Ramp down speed is 8 min.
_dat_(            min     _lbl_(end_vel), #8                          );
                  // Isolate the command bits.
_dat_(            and     _lbl_(mcmd), #$f                            );
                  // Get the right and left distances.
_dat_(            rdlong  _lbl_(right_dist), _lbl_(mpar_addr)    wz   );
                  // Got everything, so signal caller.
_dat_(            wrlong  _lbl_(mzero), par                           );
                  // If both are zero, nothing to do, so stop.
_dat_(  if_z      jmp     #_lbl_(Motor_driver_stop)                   );
                  // Get current motor directions in maccx.
_dat_(            mov     _lbl_(maccx), outa                          );
                  // Left distance is upper 16 bits, signed.
_dat_(            mov     _lbl_(left_dist), _lbl_(right_dist)         );
_dat_(            sar     _lbl_(left_dist), #$10                      );
                  // Right distance is lower 16 bits, signed.
_dat_(            shl     _lbl_(right_dist), #$10                     );
_dat_(            sar     _lbl_(right_dist), #$10                     );
                  // Get abs distance.
_dat_(            abs     _lbl_(right_dist), _lbl_(right_dist)    wc  );
                  // Toggle maccx dir bit if direction is positive.
_dat_(  if_nc     xor     _lbl_(maccx), _lbl_(right_dir_bit)          );
                  // Double it.
_dat_(            shl     _lbl_(right_dist), #1                       );
                  // Have to move at least one encoder pulse.
_dat_(            min     _lbl_(right_dist), #1                       );
                  // Set the direction according to former sign.
_dat_(            muxnc   outa, _lbl_(right_dir_bit)                  );
                  // Same for left side.
_dat_(            abs     _lbl_(left_dist), _lbl_(left_dist)    wc    );
_dat_(  if_nc     xor     _lbl_(maccx), _lbl_(left_dir_bit)           );
_dat_(            shl     _lbl_(left_dist), #1                        );
_dat_(            min     _lbl_(left_dist), #1                        );
_dat_(            muxnc   outa, _lbl_(left_dir_bit)                   );
                  // Did either direction change from last time?
_dat_(            test    _lbl_(maccx), _lbl_(both_dir_bits)    wz    );
                  //  Yes: Reset the current velocity status.
_dat_(  if_nz     jmpret  _lbl_(rst_vel_ret), #_lbl_(rst_vel)         );
                  // Compute the maximum of the two distances.
_dat_(            mov     _lbl_(max_dist), _lbl_(left_dist)           );
_dat_(            min     _lbl_(max_dist), _lbl_(right_dist)          );
                  // Zero the ramp counter.
_dat_(            mov     _lbl_(ramp_count), #0                       );
                  // Get ready to multiply distances.
_dat_(            mov     _lbl_(macc), _lbl_(left_dist)               );
_dat_(            mov     _lbl_(maccx), _lbl_(right_dist)             );
                  // Now multiply distances together.
_dat_(            jmpret  _lbl_(umult_ret), #_lbl_(umult)             );
                  // And save in left and right count-down counters.
_dat_(            mov     _lbl_(right_count), _lbl_(macc)             );
_dat_(            mov     _lbl_(left_count), _lbl_(macc)              );
                  // Is left distance less than right distance?
_dat_(            cmp     _lbl_(left_dist), _lbl_(right_dist)    wc   );
                  //  Yes: Right wheel is dominant.
_dat_(  if_c      mov     _lbl_(right_dom), #1                        );
_dat_(  if_c      mov     _lbl_(left_dom), #0                         );
                  //  No:  Left wheel is dominant.
_dat_(  if_nc     mov     _lbl_(left_dom), #1                         );
_dat_(  if_nc     mov     _lbl_(right_dom), #0                        );
                  // Kill the PWM.
_dat_(            mov     phsa, #0                                    );
_dat_(            mov     phsb, #0                                    );
                  // Initialize counters.
_dat_(            mov     ctra, _lbl_(mctra0)                         );
_dat_(            mov     ctrb, _lbl_(mctrb0)                         );
                  // Initialize timer.
_dat_(            mov     _lbl_(mtime), cnt                           );
_dat_(            add     _lbl_(mtime), _lbl_(mdt)                    );
                  // Initialize timeout interval timer.
_dat_(            mov     _lbl_(mdtimeout), _lbl_(mdto)               );
                  // Tell hub we're moving.
_dat_(            mov     _lbl_(mot_stat), #SCRIBBLER_MOT_RUNNING     );
_dat_(            jmpret  _lbl_(put_stat_ret), #_lbl_(put_stat)       );
                  // Reinitialize idler count.
_dat_(            rdword  _lbl_(idler_cnt), _lbl_(midler_addr)        );
_dat_(  Motor_driver_motor_lp:                                        );
_dat_(            tjnz    _lbl_(stat_ctr), #_lbl_(Motor_driver_chk_spd));
_dat_(            mov     _lbl_(left_vel), #0                         );
_dat_(            mov     _lbl_(right_vel), #0                        );
_dat_(            mov     _lbl_(stat_ctr), #5                         );
_dat_(  Motor_driver_chk_spd:                                         );
_dat_(            tjnz    _lbl_(motor_ctr), #_lbl_(Motor_driver_go)   );
                  // Beginning of speed epoch. Set epoch length.
_dat_(            mov     _lbl_(motor_ctr), #$190                     );
                  // Initialize velocity counter.
_dat_(            mov     _lbl_(vel_ctr), #0                          );
_dat_(  Motor_driver_go:                                              );
                  // Peek at command word.
_dat_(            rdlong  _lbl_(macc), par                            );
                  // Is there an immediate command there?
_dat_(            test    _lbl_(macc), #SCRIBBLER_MOT_IMM    wz       );
                  //  Yes: Drop everything and go do it.
_dat_(  if_nz     jmp     #_lbl_(Motor_driver_chk_cmd)                );
                  // Initialize target velocity to max.
_dat_(            mov     _lbl_(targ_vel), #$f                        );
                  // Are we timing this stroke?
_dat_(            test    _lbl_(mcmd), #SCRIBBLER_MOT_TIMED    wz     );
                  //  No:  Skip timing part.
_dat_(  if_z      jmp     #_lbl_(Motor_driver_timeout_ok)             );
                  //  Yes: Count the LSBs down first. Zero?
_dat_(            djnz    _lbl_(mdtimeout), #_lbl_(Motor_driver_timeout_ok));
                  //         Yes: Reinitialize LSBs.
_dat_(            mov     _lbl_(mdtimeout), _lbl_(mdto)               );
                  //              Decrement main timeout timer. Zero?
_dat_(            sub     _lbl_(motor_timer), #1    wz                );
                  //                Yes: Done, so get another command.              
_dat_(  if_z      jmp     #_lbl_(Motor_driver_main_lp)                );
                  //                No:  Need to ramp down if nearing end.
_dat_(            mov     _lbl_(macc), _lbl_(motor_timer)             );
_dat_(            shr     _lbl_(macc), #4                             );
_dat_(            max     _lbl_(targ_vel), _lbl_(macc)                );
_dat_(  Motor_driver_timeout_ok:                                      );
                  // Running continuously?
_dat_(            test    _lbl_(mcmd), #SCRIBBLER_MOT_CONT    wz      );
                  //  No:  Skip continuous adjustment.
_dat_(  if_z      jmp     #_lbl_(Motor_driver_ramp_down)              );
                  // Yes: Can right and left counts be augmented?
_dat_(            cmp     _lbl_(right_count), _lbl_(top_dist)    wz, wc);
_dat_(  if_z_or_c cmp     _lbl_(left_count), _lbl_(top_dist)    wz, wc);
                  //         Yes: Augment both the same.
_dat_(  if_z_or_c add     _lbl_(right_count), _lbl_(top_dist)         );
_dat_(  if_z_or_c add     _lbl_(left_count), _lbl_(top_dist)          );
                  //       Skip the ramp down. 
_dat_(            jmp     #_lbl_(Motor_driver_ramp_up)                );
_dat_(  Motor_driver_ramp_down:                                       );
                  //  No:  Compute distance from end of stroke.
_dat_(            mov     _lbl_(macc), _lbl_(max_dist)                );
_dat_(            sub     _lbl_(macc), _lbl_(ramp_count)              );
                  //       Divide by eight.
_dat_(            shr     _lbl_(macc), #3                             );
                  //       But no less than end velocity.
_dat_(            min     _lbl_(macc), _lbl_(end_vel)                 );
                  //       This is ramp-down velocity.
_dat_(            max     _lbl_(targ_vel), _lbl_(macc)                );
_dat_(  Motor_driver_ramp_up:                                         );
                  // Get distance from beginning of stroke.
_dat_(            mov     _lbl_(macc), _lbl_(ramp_count)              );
                  // Divide by two.
_dat_(            shr     _lbl_(macc), #2                             );
_dat_(            add     _lbl_(cur_vel), #1                          );
                  // But no less than current velocity.
_dat_(            min     _lbl_(macc), _lbl_(cur_vel)                 );
_dat_(            sub     _lbl_(cur_vel), #1                          );
                  // This is ramp-up velocity. Use the smaller of the two ramp values.
_dat_(            max     _lbl_(targ_vel), _lbl_(macc)                );
                  // But no bigger than max velocity,
_dat_(            max     _lbl_(targ_vel), _lbl_(max_vel)             );
                  //  and no less than two.
_dat_(            min     _lbl_(targ_vel), #2                         );
_dat_(  Motor_driver_cont_ok:                                         );
                  // Get right encoder input.
_dat_(            test    _lbl_(right_enc_bit), ina    wc             );
                  // Shift it into register.
_dat_(            rcl     _lbl_(right_enc), #1                        );
                  // Test last two bits.
_dat_(            test    _lbl_(right_enc), #3    wc                  );
                  // If different, increment right wheel velocity.
_dat_(  if_c      add     _lbl_(right_vel), #1                        );
                  // If different, subtract left distance from counter if any counts left.
_dat_(  if_c      cmpsub  _lbl_(right_count), _lbl_(left_dist)    wz  );
                  // If different and if this wheel dominates, increment velocity counter.
_dat_(  if_c      add     _lbl_(vel_ctr), _lbl_(right_dom)            );
                  // Also increment ramp_counter if this wheel dominates. 
_dat_(  if_c      add     _lbl_(ramp_count), _lbl_(right_dom)         );
                  // If counter is zero, done with this motor. Kill output.
_dat_(  if_c_and_z mov     ctra, #0                                   );
                  // Same for left encoder.
_dat_(            test    _lbl_(left_enc_bit), ina    wc              );
_dat_(            rcl     _lbl_(left_enc), #1                         );
_dat_(            test    _lbl_(left_enc), #3    wc                   );
_dat_(  if_c      add     _lbl_(left_vel), #1                         );
_dat_(  if_c      cmpsub  _lbl_(left_count), _lbl_(right_dist)    wz  );
_dat_(  if_c      add     _lbl_(vel_ctr), _lbl_(left_dom)             );
_dat_(  if_c      add     _lbl_(ramp_count), _lbl_(left_dom)          );
_dat_(  if_c_and_z mov     ctrb, #0                                   );
                  // Make sure ramp_count doesn't overflow.
_dat_(            max     _lbl_(ramp_count), _lbl_(max_dist)          );
                  // Initialize both PWMs to nominal value,
_dat_(            mov     _lbl_(right_pwm), _lbl_(nominal_pwm)        );
                  //  ahead of pulse-deletion.
_dat_(            mov     _lbl_(left_pwm), _lbl_(nominal_pwm)         );
                  // Is either encoder ahead of the other?
_dat_(            cmp     _lbl_(right_count), _lbl_(left_count)    wz, wc);
                  //      No:  Jump around. No pulse deletions this time. 
_dat_(  if_z      jmp     #_lbl_(Motor_driver_coord_ok)               );
                  //      Yes: Jump if left side is ahead.                 
_dat_(  if_nc     jmp     #_lbl_(Motor_driver_lahead)                 );
_dat_(  Motor_driver_rahead:                                          );
                  // Right side is ahead. More than one pulse?
_dat_(            mov     _lbl_(macc), _lbl_(left_count)              );
_dat_(            sub     _lbl_(macc), _lbl_(right_dist)              );
                  // Dominant?
_dat_(            cmp     _lbl_(right_dist), _lbl_(left_dist)    wz, wc);
                  //    Yes: Must be two pulses ahead to delete PWM.
_dat_(  if_nc_and_nz cmp     _lbl_(right_count), _lbl_(macc)    wc    );
                  // Drop PWM pulse if too far ahead.
_dat_(  if_c_or_z mov     _lbl_(right_pwm), #0                        );
                  // Done here.
_dat_(            jmp     #_lbl_(Motor_driver_coord_ok)               );
_dat_(  Motor_driver_lahead:                                          );
                  // Left side is dominant. Same logic as right side's.
_dat_(            mov     _lbl_(macc), _lbl_(right_count)             );
_dat_(            sub     _lbl_(macc), _lbl_(left_dist)               );
_dat_(            cmp     _lbl_(left_dist), _lbl_(right_dist)    wz, wc);
_dat_(  if_nc_and_nz cmp     _lbl_(left_count), _lbl_(macc)    wc     );
_dat_(  if_c_or_z mov     _lbl_(left_pwm), #0                         );
_dat_(  Motor_driver_coord_ok:                                        );
                  // Send debug data to hub.
_dat_(            jmpret  _lbl_(put_debug_ret), #_lbl_(put_debug)     );
                  // Are both counters now zero?
_dat_(            or      _lbl_(right_count), _lbl_(left_count)    wz, nr);
                  //      Yes: Target reached; we're done. (Already stopped individually.)
_dat_(  if_z      jmp     #_lbl_(Motor_driver_main_lp)                );
                  // Wait for next PWM period to start.
_dat_(            waitcnt _lbl_(mtime), _lbl_(mdt)                    );
                  // Put PWM widths into each counter.
_dat_(            neg     phsa, _lbl_(right_pwm)                      );
_dat_(            neg     phsb, _lbl_(left_pwm)                       );
                  // End of this velocity epoch? Loop back if not.
_dat_(            djnz    _lbl_(motor_ctr), #_lbl_(Motor_driver_motor_lp));
                  // Current velocity is velocity counter at end of epoch.
_dat_(            mov     _lbl_(cur_vel), _lbl_(vel_ctr)              );
                  // How does it compare to target velocity?
_dat_(            cmp     _lbl_(cur_vel), _lbl_(targ_vel)    wz, wc   );
_dat_(            mov     _lbl_(macc), _lbl_(cur_vel)                 );
_dat_(            shl     _lbl_(macc), #4                             );
_dat_(            min     _lbl_(macc), #$100                          );
                  // Correct PWM to get closer to target velocity.
_dat_(  if_nz     sumnc   _lbl_(nominal_pwm), _lbl_(macc)             );
_dat_(            mins    _lbl_(nominal_pwm), #0                      );
_dat_(            maxs    _lbl_(nominal_pwm), _lbl_(mdt)              );
                  // Back for more unless stat inteval is over.
_dat_(            djnz    _lbl_(stat_ctr), #_lbl_(Motor_driver_motor_lp));
                  // Get the current idler count.
_dat_(            rdword  _lbl_(maccx), _lbl_(midler_addr)            );
                  // Subtract the previous count. Any change?
_dat_(            sub     _lbl_(maccx), _lbl_(idler_cnt)    wz        );
                  //  Yes: Reset the idler timer.
_dat_(  if_nz     mov     _lbl_(idler_timer), #0                      );
                  //  No:  Increment the idler timer,
_dat_(  if_z      add     _lbl_(idler_timer), #1                      );
                  //         but not past 255.         
_dat_(  if_z      max     _lbl_(idler_timer), #$ff                    );
                  // Make idler_cnt equal current count.
_dat_(            add     _lbl_(idler_cnt), _lbl_(maccx)              );
                  // Saturate instantaneous count to 3.
_dat_(            max     _lbl_(maccx), #3                            );
                  // Add to idler velocity.
_dat_(            add     _lbl_(idler_vel), _lbl_(maccx)              );
                  // Shift two bits into idler_reg.
_dat_(            shr     _lbl_(maccx), #1    wc                      );
_dat_(            rcr     _lbl_(idler_reg), #1    wc                  );
                  // Subtract the value that comes out the other end.
_dat_(  if_c      sub     _lbl_(idler_vel), #1                        );
_dat_(            shr     _lbl_(maccx), #1    wc                      );
_dat_(            rcr     _lbl_(idler_reg), #1    wc                  );
_dat_(  if_c      sub     _lbl_(idler_vel), #2                        );
                  // Indicate that we're still running.
_dat_(            mov     _lbl_(mot_stat), #SCRIBBLER_MOT_RUNNING     );
                  // Write status info to hub.
_dat_(            jmpret  _lbl_(put_stat_ret), #_lbl_(put_stat)       );
                  // Back for another 1/10 second.
_dat_(            jmp     #_lbl_(Motor_driver_motor_lp)               );
_dat_(  clr_stat:                                                     );
                  // -------[ Clear status info to hub. ]------------------------------------------
_dat_(            jmpret  _lbl_(rst_vel_ret), #_lbl_(rst_vel)         );
_dat_(            mov     _lbl_(mot_stat), #SCRIBBLER_MOT_STOPPED     );
_dat_(  put_stat:                                                     );
                  // -------[ Write status info to hub. ]------------------------------------------
                  // Create status long. Get sign of left velocity.
_dat_(            test    outa, _lbl_(left_dir_bit)    wc             );
                  // Saturate left velocity magnitude to 127. 
_dat_(            max     _lbl_(left_vel), #$7f                       );
                  // Move signed velocity into maccx.
_dat_(            negnc   _lbl_(maccx), _lbl_(left_vel)               );
                  // Move it into position.
_dat_(            shl     _lbl_(maccx), #$18                          );
                  // OR it into status long.
_dat_(            or      _lbl_(mot_stat), _lbl_(maccx)               );
                  // Do the same for right wheel.
_dat_(            test    outa, _lbl_(right_dir_bit)    wc            );
_dat_(            max     _lbl_(right_vel), #$7f                      );
_dat_(            negnc   _lbl_(maccx), _lbl_(right_vel)              );
_dat_(            shl     _lbl_(maccx), #$18                          );
_dat_(            shr     _lbl_(maccx), #8                            );
_dat_(            or      _lbl_(mot_stat), _lbl_(maccx)               );
                  // Get the idler timer into position.
_dat_(            mov     _lbl_(maccx), _lbl_(idler_timer)            );
_dat_(            shl     _lbl_(maccx), #8                            );
                  // OR it into the status long.                
_dat_(            or      _lbl_(mot_stat), _lbl_(maccx)               );
                  // Get the idler velocity into position.
_dat_(            mov     _lbl_(maccx), _lbl_(idler_vel)              );
_dat_(            shl     _lbl_(maccx), #2                            );
                  // OR it into the status long.
_dat_(            or      _lbl_(mot_stat), _lbl_(maccx)               );
                  // Write the status to the hub.
_dat_(            wrlong  _lbl_(mot_stat), _lbl_(mstat_addr)          );
_dat_(  put_stat_ret:                                                 );
_dat_(  clr_stat_ret:                                                 );
_dat_(            ret                                                 );
_dat_(  put_debug:                                                    );
                  // -------[ Write debug info to hub. ]-------------------------------------------
_dat_(            mov     _lbl_(maccx), _lbl_(mstat_addr)             );
_dat_(            add     _lbl_(maccx), #4                            );
_dat_(            mov     _lbl_(macc), _lbl_(max_vel)                 );
_dat_(            shl     _lbl_(macc), #8                             );
_dat_(            or      _lbl_(macc), _lbl_(end_vel)                 );
_dat_(            shl     _lbl_(macc), #8                             );
_dat_(            or      _lbl_(macc), _lbl_(cur_vel)                 );
_dat_(            shl     _lbl_(macc), #8                             );
_dat_(            or      _lbl_(macc), _lbl_(targ_vel)                );
_dat_(            wrlong  _lbl_(macc), _lbl_(maccx)                   );
_dat_(            add     _lbl_(maccx), #4                            );
_dat_(            mov     _lbl_(macc), _lbl_(left_dist)               );
_dat_(            shl     _lbl_(macc), #$10                           );
_dat_(            or      _lbl_(macc), _lbl_(right_dist)              );
_dat_(            wrlong  _lbl_(macc), _lbl_(maccx)                   );
_dat_(            add     _lbl_(maccx), #4                            );
_dat_(            mov     _lbl_(macc), _lbl_(right_count)             );
_dat_(            wrlong  _lbl_(macc), _lbl_(maccx)                   );
_dat_(            add     _lbl_(maccx), #4                            );
_dat_(            mov     _lbl_(macc), _lbl_(left_count)              );
_dat_(            wrlong  _lbl_(macc), _lbl_(maccx)                   );
_dat_(            add     _lbl_(maccx), #4                            );
_dat_(            mov     _lbl_(macc), _lbl_(ramp_count)              );
_dat_(            shl     _lbl_(macc), #$10                           );
_dat_(            or      _lbl_(macc), _lbl_(max_dist)                );
_dat_(            wrlong  _lbl_(macc), _lbl_(maccx)                   );
_dat_(  put_debug_ret:                                                );
_dat_(            ret                                                 );
_dat_(  rst_vel:                                                      );
                  // -------[ Reset the idler wheel status ]---------------------------------------
                  // Reinitialize idler shift register to all ones. 
_dat_(            neg     _lbl_(idler_reg), #1                        );
                  // Reinitialize idler speed to 16 * 3
_dat_(            mov     _lbl_(idler_vel), #$30                      );
                  // Clear the time since last idler pulse.
_dat_(            mov     _lbl_(idler_timer), #0                      );
_dat_(            mov     _lbl_(left_vel), #0                         );
_dat_(            mov     _lbl_(right_vel), #0                        );
_dat_(            mov     _lbl_(cur_vel), #0                          );
_dat_(            mov     _lbl_(stat_ctr), #0                         );
_dat_(            mov     _lbl_(motor_ctr), #0                        );
_dat_(  rst_vel_ret:                                                  );
_dat_(            ret                                                 );
_dat_(  umult:                                                        );
                  // -------[ Unsigned 16 x 16 = 32 Multiply ]-------------------------------------
                  // maccx[31..0] = maccx[15..0] x macc[15..0]
                  // Get multiplicand into acc[31..16].
_dat_(            shl     _lbl_(maccx), #$10                          );
                  // Ready for 16 multiplier bits.
_dat_(            mov     _lbl_(mcnt), #$10                           );
                  // Get initial multiplier bit into C.
_dat_(            shr     _lbl_(macc), #1    wc                       );
_dat_(  Umult_loop:                                                   );
                  // If C set, add multiplicand into product.
_dat_(  if_c      add     _lbl_(macc), _lbl_(maccx)    wc             );
                  // Get next multiplier bit into C, shift product.
_dat_(            rcr     _lbl_(macc), #1    wc                       );
                  // Loop until done.
_dat_(            djnz    _lbl_(mcnt), #_lbl_(Umult_loop)             );
_dat_(  umult_ret:                                                    );
                  // Return with product in acc[31..0].
_dat_(            ret                                                 );
_dat_(  right_dir_bit:                                                );
                  // -------[ Constants and Initialized Variables ]--------------------------------
_dat_(            .long   (1 << SCRIBBLER_MOT_RIGHT_DIR)              );
_dat_(  left_dir_bit:                                                 );
_dat_(            .long   (1 << SCRIBBLER_MOT_LEFT_DIR)               );
_dat_(  both_dir_bits:                                                );
_dat_(            .long   ((1 << SCRIBBLER_MOT_RIGHT_DIR) | (1 << SCRIBBLER_MOT_LEFT_DIR)));
_dat_(  right_enc_bit:                                                );
_dat_(            .long   (1 << SCRIBBLER_MOT_RIGHT_ENC)              );
_dat_(  left_enc_bit:                                                 );
_dat_(            .long   (1 << SCRIBBLER_MOT_LEFT_ENC)               );
_dat_(  mdira0:                                                       );
_dat_(            .long   ((((1 << SCRIBBLER_MOT_RIGHT_PWM) | (1 << SCRIBBLER_MOT_LEFT_PWM)) | (1 << SCRIBBLER_MOT_RIGHT_DIR)) | (1 << SCRIBBLER_MOT_LEFT_DIR)));
_dat_(  mctra0:                                                       );
_dat_(            .long   ((4 << $1a) | SCRIBBLER_MOT_RIGHT_PWM)      );
_dat_(  mctrb0:                                                       );
_dat_(            .long   ((4 << $1a) | SCRIBBLER_MOT_LEFT_PWM)       );
_dat_(  top_dist:                                                     );
_dat_(            .long   $ffff                                       );
                  // Clocks in one PWM period.
_dat_(  mdt:                                                          );
_dat_(            .long   $fa0                                        );
                  // PWM periods in one timeout tick.
_dat_(  mdto:                                                         );
_dat_(            .long   $14                                         );
_dat_(  mtime:                                                        );
_dat_(            .long   0                                           );
_dat_(  mzero:                                                        );
_dat_(            .long   0                                           );
_dat_(  idler_vel:                                                    );
_dat_(            .long   0                                           );
_dat_(  midler_addr:                                                  );
_dat_(            .long   (0 - 0)                                     );
_dat_(  stat_ctr:                                                     );
_dat_(            .long   0                                           );
_dat_(  motor_ctr:                                                    );
_dat_(            .long   0                                           );
                  // Address of command parameters. (Coommand address is par.)
_dat_(  mpar_addr:                                                    );
                  // -------[ Variables ]----------------------------------------------------------
_dat_(            .res    1                                           );
                  // Address of status registers.
_dat_(  mstat_addr:                                                   );
_dat_(            .res    1                                           );
                  // General-purpose accumulator.
_dat_(  macc:                                                         );
_dat_(            .res    1                                           );
                  // General-purpose accumulator extension.
_dat_(  maccx:                                                        );
_dat_(            .res    1                                           );
                  // General-purpose counter.
_dat_(  mcnt:                                                         );
_dat_(            .res    1                                           );
                  // Command word.
_dat_(  mcmd:                                                         );
_dat_(            .res    1                                           );
                  // Timeout timer.
_dat_(  motor_timer:                                                  );
_dat_(            .res    1                                           );
                  // Timeout timer LSBs.
_dat_(  mdtimeout:                                                    );
_dat_(            .res    1                                           );
                  // Shift register for right encoder.
_dat_(  right_enc:                                                    );
_dat_(            .res    1                                           );
                  // Shift register for left encoder.
_dat_(  left_enc:                                                     );
_dat_(            .res    1                                           );
                  // Total distance for right wheel to travel.
_dat_(  right_dist:                                                   );
_dat_(            .res    1                                           );
                  // Total distance for left wheel to travel.
_dat_(  left_dist:                                                    );
_dat_(            .res    1                                           );
                  // Maximum of left_dist and right_dist.
_dat_(  max_dist:                                                     );
_dat_(            .res    1                                           );
                  // Countdown for right wheel.
_dat_(  right_count:                                                  );
_dat_(            .res    1                                           );
                  // Countdown for left wheel.
_dat_(  left_count:                                                   );
_dat_(            .res    1                                           );
                  // Countup for ramp computations.
_dat_(  ramp_count:                                                   );
_dat_(            .res    1                                           );
                  // Maximum velocity for this stroke.
_dat_(  max_vel:                                                      );
_dat_(            .res    1                                           );
                  // End velocity for this stroke.
_dat_(  end_vel:                                                      );
_dat_(            .res    1                                           );
                  // Current instantaneous velocity.
_dat_(  cur_vel:                                                      );
_dat_(            .res    1                                           );
                  // Target instantaneous velocity.
_dat_(  targ_vel:                                                     );
_dat_(            .res    1                                           );
_dat_(  right_vel:                                                    );
_dat_(            .res    1                                           );
_dat_(  left_vel:                                                     );
_dat_(            .res    1                                           );
                  // Countup for velocity computation.
_dat_(  vel_ctr:                                                      );
_dat_(            .res    1                                           );
_dat_(  idler_cnt:                                                    );
_dat_(            .res    1                                           );
                  // 1 when right wheel dominates; 0 otherwise.
_dat_(  right_dom:                                                    );
_dat_(            .res    1                                           );
                  // 1 when left wheel dominates; 0 otherwise.
_dat_(  left_dom:                                                     );
_dat_(            .res    1                                           );
                  // Nominal PWM value for dominant wheel.
_dat_(  nominal_pwm:                                                  );
_dat_(            .res    1                                           );
                  // Actual PWM value for right wheel (nominal_pwm or 0).
_dat_(  right_pwm:                                                    );
_dat_(            .res    1                                           );
                  // Actual PWM value for left wheel (nominal_pwm or 0).
_dat_(  left_pwm:                                                     );
_dat_(            .res    1                                           );
_dat_(  idler_reg:                                                    );
_dat_(            .res    1                                           );
_dat_(  idler_timer:                                                  );
_dat_(            .res    1                                           );
                  // Mirror of status long in hub.     
_dat_(  mot_stat:                                                     );
_dat_(            .res    1                                           );
_dat_(            .fit    $1f0                                        );
_dat_(  Adc_sequence:                                                 );
                  // =======[ Default ADC sequence ]===============================================
                  // Sequence array format. Values can be changed in real time if external.
                  // MUX addr[4] | Result index[4] | Soak time [4] | Filter[3] | Scale[1]
                  // MUX addr is the address of the MUX input (0 - 15).
                  // Actual soak time is 1 << value, in microseconds.
                  // Actual filter time constant is 1 << value, in milliseconds.
                  // Scale is 0 for 3.3V ref; 1 for 5V ref.
_dat_(            .word   (((SCRIBBLER__VSS | SCRIBBLER__SOAK_1US) | SCRIBBLER__LPF_64MS) | SCRIBBLER__REF_3V3));
_dat_(            .word   (((SCRIBBLER__VDD | SCRIBBLER__SOAK_1US) | SCRIBBLER__LPF_64MS) | SCRIBBLER__REF_3V3));
_dat_(            .word   (((SCRIBBLER__5V | SCRIBBLER__SOAK_1US) | SCRIBBLER__LPF_64MS) | SCRIBBLER__REF_5V0));
_dat_(            .word   (((SCRIBBLER__5V_DIV | SCRIBBLER__SOAK_1US) | SCRIBBLER__LPF_64MS) | SCRIBBLER__REF_3V3));
_dat_(            .word   (((SCRIBBLER__VBAT | SCRIBBLER__SOAK_1US) | SCRIBBLER__LPF_64MS) | SCRIBBLER__REF_3V3));
_dat_(            .word   (((SCRIBBLER__VTRIP | SCRIBBLER__SOAK_1US) | SCRIBBLER__LPF_64MS) | SCRIBBLER__REF_3V3));
_dat_(            .word   (((SCRIBBLER__IDD | SCRIBBLER__SOAK_1US) | SCRIBBLER__LPF_64MS) | SCRIBBLER__REF_5V0));
_dat_(            .word   (((SCRIBBLER__IMOT | SCRIBBLER__SOAK_1US) | SCRIBBLER__LPF_4MS) | SCRIBBLER__REF_3V3));
_dat_(            .word   (((SCRIBBLER__IDLER | SCRIBBLER__SOAK_64US) | SCRIBBLER__LPF_4MS) | SCRIBBLER__REF_3V3));
_dat_(            .word   (((SCRIBBLER__RIGHT_LGT | SCRIBBLER__SOAK_1US) | SCRIBBLER__LPF_64MS) | SCRIBBLER__REF_3V3));
_dat_(            .word   (((SCRIBBLER__CENTER_LGT | SCRIBBLER__SOAK_1US) | SCRIBBLER__LPF_64MS) | SCRIBBLER__REF_3V3));
_dat_(            .word   (((SCRIBBLER__LEFT_LGT | SCRIBBLER__SOAK_1US) | SCRIBBLER__LPF_64MS) | SCRIBBLER__REF_3V3));
_dat_(            .word   (((SCRIBBLER__RIGHT_LIN | SCRIBBLER__SOAK_64US) | SCRIBBLER__LPF_4MS) | SCRIBBLER__REF_3V3));
_dat_(            .word   (((SCRIBBLER__LEFT_LIN | SCRIBBLER__SOAK_64US) | SCRIBBLER__LPF_4MS) | SCRIBBLER__REF_3V3));
_dat_(            .word   (((SCRIBBLER__P6 | SCRIBBLER__SOAK_16US) | SCRIBBLER__LPF_4MS) | SCRIBBLER__REF_5V0));
_dat_(            .word   (((SCRIBBLER__P7 | SCRIBBLER__SOAK_16US) | SCRIBBLER__LPF_4MS) | SCRIBBLER__REF_5V0));
_dat_(            .word   0                                           );
_dat_(            .balign 4                                           );
_dat_(  Timers:                                                       );
                  // =======[ Hub variables ]======================================================
_dat_(            .long   0, 0, 0, 0, 0, 0, 0, 0                      );
_dat_(  Envelope:                                                     );
_dat_(            .long   0                                           );
_dat_(  Current_x:                                                    );
_dat_(            .long   (0 - 0)                                     );
_dat_(  Current_y:                                                    );
_dat_(            .long   (0 - 0)                                     );
_dat_(  Current_w:                                                    );
_dat_(            .long   (0 - 0)                                     );
_dat_(  Stall_hyst:                                                   );
_dat_(            .long   0                                           );
_dat_(  Full_circle:                                                  );
_dat_(            .word   SCRIBBLER_DEFAULT_FULL_CIRCLE               );
_dat_(  Wheel_space:                                                  );
_dat_(            .word   SCRIBBLER_DEFAULT_WHEEL_SPACE               );
_dat_(  Half_circle:                                                  );
_dat_(            .word   (SCRIBBLER_DEFAULT_FULL_CIRCLE / 2)         );
_dat_(  Qtr_circle:                                                   );
_dat_(            .word   (SCRIBBLER_DEFAULT_FULL_CIRCLE / 4)         );
_dat_(  Atan_circle:                                                  );
_dat_(            .long   ((SCRIBBLER_DEFAULT_FULL_CIRCLE * $de09) / $186a0));
_dat_(  Light_scale:                                                  );
_dat_(            .byte   SCRIBBLER_DEFAULT_LIGHT_SCALE, SCRIBBLER_DEFAULT_LIGHT_SCALE, SCRIBBLER_DEFAULT_LIGHT_SCALE);
_dat_(  Line_thld:                                                    );
_dat_(            .ascii  " "                                         );
_dat_(  Obstacle_thld:                                                );
_dat_(            .byte   SCRIBBLER_DEFAULT_OBSTACLE_THLD             );
_dat_(  _filler:                                                      );
_dat_(            .byte   0, 0, 0                                     );
                  // ┐
_dat_(  Motor_cmd:                                                    );
_dat_(            .word   0                                           );
                  // │
_dat_(  Motor_time:                                                   );
_dat_(            .word   0                                           );
                  // ├─ Must begin on a long boundary and be contiguous in this order.
_dat_(  Motor_Rdist:                                                  );
_dat_(            .word   0                                           );
                  // │
_dat_(  Motor_Ldist:                                                  );
_dat_(            .word   0                                           );
                  // ┘
_dat_(  Motor_stat:                                                   );
_dat_(            .long   0, 0, 0, 0, 0, 0                            );
_dat_(  Path_Rdist:                                                   );
_dat_(            .long   0                                           );
_dat_(  Path_Ldist:                                                   );
_dat_(            .long   0                                           );
_dat_(  Path_time:                                                    );
_dat_(            .long   0                                           );
_dat_(  Path_max_spd:                                                 );
_dat_(            .long   0                                           );
                  // Must begin on a long boundary.
_dat_(  Results:                                                      );
_dat_(            .word   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
                  // ┐
_dat_(  Tone_queue:                                                   );
_dat_(            .word   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
                  // │
_dat_(  Tone_enq_ptr:                                                 );
_dat_(            .word   0                                           );
                  // │
_dat_(  Tone_deq_ptr:                                                 );
_dat_(            .word   0                                           );
                  // ├─ Must be contiguous and in this order.
_dat_(  Tone_cmd:                                                     );
_dat_(            .ascii  "\0"                                        );
                  // │
_dat_(  Tone_sync:                                                    );
_dat_(            .ascii  "\0"                                        );
                  // │
_dat_(  Tone_voice1:                                                  );
_dat_(            .ascii  "\0"                                        );
                  // ┘
_dat_(  Tone_voice2:                                                  );
_dat_(            .ascii  "\0"                                        );
_dat_(  In_path:                                                      );
_dat_(            .ascii  "\0"                                        );
_dat_(  Adc_cog:                                                      );
_dat_(            .ascii  "\0"                                        );
_dat_(  Tone_cog:                                                     );
_dat_(            .ascii  "\0"                                        );
_dat_(  Mic_cog:                                                      );
_dat_(            .ascii  "\0"                                        );
_dat_(  Motor_cog:                                                    );
_dat_(            .ascii  "\0"                                        );
_dat_(  Reset_count:                                                  );
_dat_(            .ascii  "\0"                                        );
_dat_(  Current_spd:                                                  );
_dat_(            .ascii  "\0"                                        );
_dat_(  Model_number:                                                 );
_dat_(            .ascii  "\0"                                        );
//
// due to a gas bug, we need the .org constants to be unknown during the first pass
// so they have to be defined here, after all asm is done
//
_dat_(  .equ ..org0001, ..org0001_base                                );
_dat_(  .equ ..org0002, ..org0002_base                                );
_dat_(  .equ ..org0003, ..org0003_base                                );
_dat_(  .equ ..org0004, ..org0004_base                                );
_dat_(            .compress default                                   );
_dat_(            .text                                               );

// =======[ Public Spin methods... ]===============================================
//
// -------[ Start and stop methods... ]--------------------------------------------
//
// Start and stop methods are used for starting individual cogs or stopping all
// of them at once.
int32_t scribbler_start(scribbler *self)
{
  int32_t	i, Register;
  // Main start routine for scribbler object. Stops ALL cogs, so
  // IT MUST BE CALLED FIRST, before starting other cogs.
  //
  // Example: scribbler.start 'Start scribbler object.
  scribbler_stop_all();
  // Detect the robot hardware model number.
  DIRA |= (15 << 22);
  // Set the mux address to the 3V3_I_ANG input.
  OUTA = (OUTA & 0xfc3fffff) | 0x3000000;
  // Set both ADC pins to inputs.             
  DIRA &= (~(3 << 26));
  // Wait for the input to settle.
  _waitcnt((CNT + (CLKFREQ / 10)));
  if ((INA >> SCRIBBLER__MUX_ADC_IN) & 0x1) {
    Model_number[0] = SCRIBBLER_MODEL_S2;
  } else {
    Model_number[0] = SCRIBBLER_MODEL_S3;
  }
  results_addr[0] = (int32_t)(Results);
  memset( (void *)results_addr[0], 0, sizeof(uint16_t)*40);
  seq_addr[0] = (int32_t)(Adc_sequence);
  if ((Adc_cog[0] = cognew((int32_t)(adc_all), (Model_number[0] << 2)) + 1)) {
    OUTA = 0x10000000;
    DIRA = 0x10200000;
    scribbler__i2c_stop();
    if ((Reset_count[0] = scribbler__ee_rdbyte(SCRIBBLER_EE_RESET_CNT))) {
      scribbler__ee_wrbyte(SCRIBBLER_EE_RESET_CNT, 0);
    }
    if (Reset_count[0] > 8) {
      Reset_count[0] = 0;
    }
    scribbler_read_wheel_calibration();
    scribbler_read_light_calibration();
    scribbler_read_line_threshold();
    scribbler_set_led(SCRIBBLER_POWER, SCRIBBLER_BLUE);
    if (scribbler_get_model_s3()) {
      // Configure the battery charger.
      // Read the charger source control register.
      Register = scribbler__BQ2495_rdbyte(0);
      // Set Vin(min) to 5V.
      Register |= 0x70;
      // Clear HiZ disable bit.
      Register &= 0x7f;
      // Write the updated register back.
      scribbler__BQ2495_wrbyte(0, Register);
      // OTG Enable, Charge Enable, Watch Dog Reset, Vsys Min 3.0V.
      scribbler__BQ2495_wrbyte(1, 113);
      // Ichrg = 1984 mA.
      scribbler__BQ2495_wrbyte(2, 92);
      // I PreChrg 512 mA, I term 128 mA.
      scribbler__BQ2495_wrbyte(3, 48);
      // Vchrg 4.208, Bat Low 3.0V.
      scribbler__BQ2495_wrbyte(4, 178);
      // Charge Term En, WatchDog Dis, Chg Tmr 20 hours. 
      scribbler__BQ2495_wrbyte(5, 142);
      // Boost = 5.062V, Bhot 65C, Treg 100C. 
      scribbler__BQ2495_wrbyte(6, 138);
      // TMR2x En, BATFET On, Disable Interupts.
      scribbler__BQ2495_wrbyte(7, 72);
    }
    scribbler_delay_tenths(self, 5);
    return -1;
  } else {
    return 0;
  }
}

int32_t scribbler_start_motors(void)
{
  int32_t result = 0;
  // Start motor control cog.
  //
  // Example: scribbler.start_motors 'Start the motor controller.
  if (!(Motor_cog[0])) {
    Motor_cmd[0] = -1;
    midler_addr[0] = (int32_t)(Results) + (SCRIBBLER_CNT_IDLER << 1);
    result = -((Motor_cog[0] = cognew((int32_t)(motor_driver), (int32_t)(Motor_cmd)) + 1) > 0);
    while (Motor_cmd[0]) {
      Yield__();
    }
    In_path[0] = 0;
    scribbler_here_is(0, 0);
    scribbler_heading_is(Qtr_circle[0]);
    scribbler_set_speed(7);
  }
  return result;
}

int32_t scribbler_start_tones(scribbler *self)
{
  int32_t result = 0;
  // Start tone sequencer.
  //
  // Example: scribbler.start_tones 'Start the tone sequencer/generator.
  if (!(Tone_cog[0])) {
    memset( (void *)(int32_t)(Tone_queue), 0, sizeof(uint16_t)*(SCRIBBLER__TONE_Q_SIZE + 4));
    dttime[0] = (CLKFREQ / 65536) * 2;
    queue_addr[0] = (int32_t)(Tone_queue);
    result = -((Tone_cog[0] = cognew((int32_t)(tone_seq), 0) + 1) > 0);
    scribbler_command_tone(SCRIBBLER_PLAY);
  }
  return result;
}

int32_t scribbler_start_mic_env(scribbler *self)
{
  // Start microphone Envelope detector.
  //
  // Example: scribbler.start_mic_env 'Start the microphone Envelope detector.
  if (!(Mic_cog[0])) {
    mic_dt[0] = CLKFREQ / 8000;
    mic_cyc[0] = 8000 / 20;
    return -((Mic_cog[0] = cognew((int32_t)(env_det), (int32_t)(Envelope)) + 1) > 0);
  }
  return 0;
}

void scribbler_stop_all(void)
{
  int32_t	_tmp__0002, _tmp__0003, _tmp__0004, _tmp__0005;
  // Stop ALL cogs.
  //
  // Example: scribbler.stop_all 'Stop all scribbler cogs.
  if (Adc_cog[0]) {
    __builtin_propeller_cogstop((( ( (_tmp__0002 = Adc_cog[0]), (Adc_cog[0] = 0) ), _tmp__0002 ) - 1));
  }
  if (Tone_cog[0]) {
    __builtin_propeller_cogstop((( ( (_tmp__0003 = Tone_cog[0]), (Tone_cog[0] = 0) ), _tmp__0003 ) - 1));
  }
  if (Mic_cog[0]) {
    __builtin_propeller_cogstop((( ( (_tmp__0004 = Mic_cog[0]), (Mic_cog[0] = 0) ), _tmp__0004 ) - 1));
  }
  if (Motor_cog[0]) {
    __builtin_propeller_cogstop((( ( (_tmp__0005 = Motor_cog[0]), (Motor_cog[0] = 0) ), _tmp__0005 ) - 1));
  }
}

/* 
---------[ Microphone methods... ]---------------------------------------------

   Microphone methods provide data from the scribbler's built-in microphone.
 */
int32_t scribbler_get_mic_env(void)
{
  // Get the average loudness (Envelope) value of the microphone input.
  //
  // Example: loudness := scribbler.get_mic_env 'Set loudness equal to current mic level.
  return Envelope[0];
}

/* 
---------[ Drawing methods... ]---------------------------------------------------

   Drawing methods can be used for drawing with the scribbler or for any application
   that requires keeping track of the robot's position and heading.
 */
void scribbler_begin_path(void)
{
  // Begin a path of connected movements.
  //
  // Example: scribbler.begin_path
  if (!(In_path[0])) {
    In_path[0] = 1;
  }
}

void scribbler_end_path(void)
{
  // Output the last movement in the path, if there is one, and end the path.
  // NOTE: Omitting this statement may cause the last path segment not to be drawn.
  //
  // Example: scribbler.end_path
  if (In_path[0] == 2) {
    scribbler_run_motors(0, Path_Ldist[0], Path_Rdist[0], Path_time[0], Path_max_spd[0], 0);
  }
  In_path[0] = 0;
}

void scribbler_set_speed(int32_t spd)
{
  // Set the speed (0 - 15) for the drawing methods, along with the "go_", "turn_",
  // and "arc_" motion methods.
  //
  // Example: set_speed(7) 'Set the speed to half of maximum velocity.
  Current_spd[0] = spd;
}

void scribbler_move_to(int32_t x, int32_t y)
{
  // Move directly to the point (x, y).
  // Units are approximately 0.5mm.
  //
  // Example: scribbler.move_to(1000, 50) 'Move to a point 500 mm to the right and 25mm above the origin.
  scribbler_move_by((x - Current_x[0]), (y - Current_y[0]));
}

void scribbler_arc_to(int32_t x, int32_t y, int32_t radius)
{
  // Move to the point (x, y) via an arc of the specified radius (+radius is CCW; -radius is CW).
  // The Cartesian distance from the current location to the target position must be no more than
  // 2 * radius. If it's greater than that, the robot will move in a straight line to the target
  // position first to make up the difference, then perform the arc.
  // Units are approximately 0.5mm.
  //
  // Example: scribbler.arc_to(1000, 50, -100) 'Move to the point 500 mm to the right and 25mm above the origin
  //                                    '  in a clockwise arc of radius 25mm.
  scribbler_arc_by((x - Current_x[0]), (y - Current_y[0]), radius);
}

void scribbler_move_by(int32_t dx, int32_t dy)
{
  int32_t	angle;
  // Move from the current location by the displacement (dx, dy).
  // Units are approximately 0.5mm.
  //
  // Example: scribbler.move_by(100, 50) 'Move to a point 50 mm to the right and 25mm above the current location.
  scribbler_turn_to((angle = scribbler__atan2(dy, dx)));
  scribbler_go_forward((Sqrt__(((dx * dx) + (dy * dy)))));
  scribbler_here_is((Current_x[0] + dx), (Current_y[0] + dy));
}

void scribbler_arc_by(int32_t dx, int32_t dy, int32_t radius)
{
  int32_t	dist2, dist, diam, half_angle, tilt;
  // Move from the current location byt the displacement (dx, dy) via an arc of the specified radius
  // (+radius is CCW; -radius is CW). The Cartesian length of the displacement must be no more than
  // 2 * radius. If it's greater than that, the robot will move in a straight line to the target
  // position first to make up the difference, then perform the arc. Units are approximately 0.5mm.
  //
  // Example: scribbler.arc_by(50, 50, -100) 'Move to the point 25 mm to the right of and 25mm above the 
  //                                  '  current location in a clockwise arc of radius 50mm.
  dist2 = (dx * dx) + (dy * dy);
  dist = Sqrt__(dist2);
  tilt = scribbler__atan2(dy, dx);
  diam = (abs(radius)) << 1;
  if (dist > diam) {
    scribbler_turn_to(tilt);
    scribbler_go_forward((dist - diam));
    dist = diam;
    dist2 = dist * dist;
  }
  half_angle = scribbler__atan2((Shr__(dist, 1)), (Sqrt__(((radius * radius) - (Shr__(dist2, 2))))));
  if (radius < 0) {
    half_angle = -half_angle;
  }
  scribbler_turn_to((tilt - half_angle));
  scribbler_arc((half_angle << 1), radius);
  scribbler_here_is((Current_x[0] + dx), (Current_y[0] + dy));
  scribbler_heading_is((tilt + half_angle));
}

int32_t scribbler_align_with(int32_t heading)
{
  int32_t	dw;
  int32_t result = 0;
  // Turn so that the robot is pointed parallel to the desired heading (scribbler angle units),
  // either in the selected direction (returns 1) or opposite the selected direction
  // (returns -1), whichever requires the shortest turn to achieve.
  //
  // Example: dir := scribbler.align_with(150) 'Point the robot to angle 150 (scribbler angle units)
  //                                    '  or opposite that angle. Set dir to ±1, accordingly.
  dw = (heading - Current_w[0]) % Full_circle[0];
  dw = dw + (Full_circle[0] & -(dw < 0));
  if (dw > Half_circle[0]) {
    dw = dw - Full_circle[0];
  }
  if ((abs(dw)) <= Qtr_circle[0]) {
    result = 1;
  } else {
    dw = (dw - Half_circle[0]) + (Full_circle[0] & -(dw < 0));
    result = -1;
  }
  scribbler_turn(dw);
  scribbler_heading_is((Current_w[0] + dw));
  return result;
}

void scribbler_turn_to_deg(int32_t heading)
{
  // Turn the robot to the desired heading (degrees).
  //
  // Example: scribbler.turn_to(135) 'Point the robot to an angle of 135 degrees.
  scribbler_turn_to(((heading * Full_circle[0]) / 360));
}

void scribbler_turn_to(int32_t heading)
{
  // Turn the robot to the desired heading (scribbler angle units).
  //
  // Example: scribbler.turn_to(500) 'Point the robot to an angle of 500 scribbler angle units.
  scribbler_turn_by((heading - Current_w[0]));
}

void scribbler_turn_by_deg(int32_t dw)
{
  // Turn the robot by the desired amount (degrees). +dw is CCW; -dw is CW.
  // If the net turn angle is greater than 180 degrees, the shorter rotation
  // in the opposite direction is used instead.
  //
  // Example: scribbler.turn_by_deg(90) 'Rotate the robot by an angle of 90 degrees CCW.
  scribbler_turn_by(((dw * Full_circle[0]) / 360));
}

int32_t scribbler_turn_by(int32_t dw)
{
  // Turn the robot by the desired amount (scribbler angle units). +dw is CCW; -dw is CW.
  // If the net turn angle is greater than Full_circle / 2, the shorter rotation
  // in the opposite direction is used instead.
  //
  // Example: scribbler.turn_by(500) 'Rotate the robot by an angle of 500 scribbler angle units CCW.
  dw = dw % Full_circle[0];
  dw = dw + (Full_circle[0] & -(dw < 0));
  if (dw > Half_circle[0]) {
    dw = dw - Full_circle[0];
  }
  scribbler_turn(dw);
  scribbler_heading_is((Current_w[0] + dw));
  return 1;
}

void scribbler_here_is(int32_t x, int32_t y)
{
  // Reset the current position to (x,y). Units are approximately 0.5mm.
  //
  // Example: scribbler.here_is(0, 0) 'Reset the origin to the current location.
  Current_x[0] = x;
  Current_y[0] = y;
}

void scribbler_heading_is_deg(int32_t w)
{
  // Reset the current heading to w degrees.
  //
  // Example: scribbler.heading_is_deg(90) 'Reset the current heading to 90 degrees.
  scribbler_heading_is(((w * Full_circle[0]) / 360));
}

void scribbler_heading_is(int32_t w)
{
  // Reset the current heading to w.
  //
  // Example: scribbler.heading_is(567) 'Reset the current heading to 567.
  Current_w[0] = w % Full_circle[0];
  Current_w[0] = Current_w[0] + (Full_circle[0] & -(Current_w[0] < 0));
}

/* 
---------[ Motion methods... ]-------------------------------------------------

   Motion methods control the movement of the scribbler robot. MOTION METHODS DO NOT
   KEEP TRACK OF THE SCRIBBLERS'S POSITION AND HEADING, unless called from one of the
   drawing methods. As such, they should NOT be mixed with calls to drawing
   methods.
 */
int32_t scribbler_read_wheel_calibration(void)
{
  int32_t _local__0006[2];
  // Read calibration values from EEPROM, and use them if they're reasonable.
  // Returns a packed long containing the calibration values. If no valid values
  // exist in EEPROM, sets (and returns) the default values.
  //
  // Example: scribbler.read__wheel_calibration 'Get previously-written wheel calibration values.
  if (scribbler__ee_rdblock((int32_t)(&_local__0006[0]), SCRIBBLER_EE_WHEEL_CALIB, 4)) {
    _local__0006[1] = Shr__(_local__0006[0], 16);
    _local__0006[0] &= 0xffff;
    if ((((_local__0006[0] > 900) && (_local__0006[0] < 1000)) && (_local__0006[1] > 100)) && (_local__0006[1] < 200)) {
      return scribbler_set_wheel_calibration(_local__0006[0], _local__0006[1]);
    }
  }
  return scribbler_default_wheel_calibration();
}

int32_t scribbler_write_wheel_calibration(void)
{
  // Write current wheel calibration values to EEPROM.
  // Returns true on success, false on failure.
  //
  // Example: scribbler.write_wheel_calibration 'Write Full_circle and Wheel_space to EEPROM.
  return scribbler__ee_wrblock((int32_t)(Full_circle), SCRIBBLER_EE_WHEEL_CALIB, 4);
}

int32_t scribbler_default_wheel_calibration(void)
{
  // Restore calibration to default values. DOES NOT SAVE IN EEPROM.
  // This method is optional unless read_calibration or set_calibration
  // have been called.
  //
  // Example: scribbler.default_calibration 'Restore calibration defaults.
  return scribbler_set_wheel_calibration(SCRIBBLER_DEFAULT_FULL_CIRCLE, SCRIBBLER_DEFAULT_WHEEL_SPACE);
}

int32_t scribbler_set_wheel_calibration(int32_t circle, int32_t space)
{
  // Set calibration values to method's arguments, if they're reasonable.
  // DOES NOT SAVE IN EEPROM.
  //
  // Example: scribbler.set_wheel_calibration(960, 160) 'Set Full_circle to 960 and
  //                                             'Wheel_space to 160.
  Full_circle[0] = circle;
  Wheel_space[0] = space;
  scribbler__compute_calibration();
  return scribbler_get_wheel_calibration();
}

int32_t scribbler_get_wheel_calibration(void)
{
  // Gets current calibration values: Full_circle in top 16 bits;
  // Wheel_space in bottom 16 bits.
  return ((Full_circle[0] << 16) | Wheel_space[0]);
}

void scribbler_go_left(int32_t dist)
{
  // Turn left and go forward from there by the indicated distance. Units are
  // approximately 0.5mm.
  //
  // Example: scribbler.go_left(500) 'Turn left and move forward 250mm.
  scribbler_turn_deg(90);
  scribbler_go_forward(dist);
}

void scribbler_go_right(int32_t dist)
{
  // Turn right and go forward from there by the indicated distance. Units are
  // approximately 0.5mm.
  //
  // Example: scribbler.go_right(500) 'Turn right and move forward 250mm.
  scribbler_turn_deg((-90));
  scribbler_go_forward(dist);
}

void scribbler_go_forward(int32_t dist)
{
  // Go forward by the indicated distance. Units are approximately 0.5mm.
  //
  // Example: scribbler.go_forward(500) 'Move forward 250mm.
  if ((abs(dist)) == SCRIBBLER_FOREVER) {
    scribbler_move(100, 100, 0, Current_spd[0], 1);
  } else {
    scribbler_move(dist, dist, 0, Current_spd[0], 0);
  }
}

void scribbler_go_back(int32_t dist)
{
  // Go backward by the indicated distance. Units are approximately 0.5mm.
  //
  // Example: scribbler.go_back(500) 'Move back 250mm.
  if ((abs(dist)) == SCRIBBLER_FOREVER) {
    scribbler_move((-100), (-100), 0, Current_spd[0], 1);
  } else {
    scribbler_move((-dist), (-dist), 0, Current_spd[0], 0);
  }
}

void scribbler_turn_deg(int32_t ccw_degrees)
{
  // Turn in place counter-clockwise by the indicated number of degrees.
  // Negative values will turn clockwise.
  //
  // Example: scribbler.turn_deg(-90) 'Turn right.
  scribbler_arc_deg(ccw_degrees, 0);
}

void scribbler_arc_deg(int32_t ccw_degrees, int32_t radius)
{
  int32_t	r, l;
  // Move in a counter-clockwise arc of the indicated radius by the specified
  // number of degrees. Radius units are approximately 0.5mm. Negative angles
  // result in a clockwise arc.
  //
  // Example: scribbler.arc_deg(90, 500) 'Make a sweeping left turn with a radius of 250mm.
  scribbler_arc(((Full_circle[0] * ccw_degrees) / 360), radius);
}

void scribbler_turn(int32_t ccw_units)
{
  // Turn in place counter-clockwise by the indicated number of degrees.
  // Negative values will turn clockwise.
  //
  // Example: scribbler.turn(-50) 'Turn a bit to the right by 50 scribbler angle units.
  scribbler_arc(ccw_units, 0);
}

void scribbler_arc(int32_t ccw_units, int32_t radius)
{
  int32_t	r, l;
  // Move in a counter-clockwise arc of the indicated radius by the specified
  // number of scribbler angle units. Radius units are approximately 0.5mm. Negative angles
  // result in a clockwise arc.
  //
  // Example: scribbler.arc(100, 50) 'Arc a bit to the left by 100 scribbler angle units with
  //                          '  a 25mm radius.
  r = (ccw_units * (radius + Wheel_space[0])) / Wheel_space[0];
  l = (ccw_units * (radius - Wheel_space[0])) / Wheel_space[0];
  scribbler_move(l, r, 0, Current_spd[0], 0);
}

void scribbler_turn_deg_now(int32_t ccw_degrees)
{
  // Turn in place counter-clockwise by the indicated number of degrees.
  // Negative values will turn clockwise.
  // Preempts current motion in progress.
  //
  // Example: scribbler.turn_deg_now(-90) 'Immediate turn right.
  scribbler_arc_deg_now(ccw_degrees, 0);
}

void scribbler_arc_deg_now(int32_t ccw_degrees, int32_t radius)
{
  int32_t	r, l;
  // Move in a counter-clockwise arc of the indicated radius by the specified
  // number of degrees. Radius units are approximately 0.5mm. Negative angles
  // result in a clockwise arc.
  // Preempts current motion in progress.
  //
  // Example: scribbler.arc_deg_now(90, 500) 'Make an immediate sweeping left turn
  //                                  'with a radius of 250mm.
  scribbler_arc_now(((Full_circle[0] * ccw_degrees) / 360), radius);
}

void scribbler_turn_now(int32_t ccw_units)
{
  // Turn in place counter-clockwise by the indicated number of degrees.
  // Negative values will turn clockwise.
  // Preempts current motion in progress.
  //
  // Example: scribbler.turn_now(-50) 'Immediately turn a bit to the right by 50 scribbler angle units.
  scribbler_arc_now(ccw_units, 0);
}

void scribbler_arc_now(int32_t ccw_units, int32_t radius)
{
  int32_t	r, l;
  // Move in a counter-clockwise arc of the indicated radius by the specified
  // number of scribbler angle units. Radius units are approximately 0.5mm. Negative angles
  // result in a clockwise arc.
  // Preempts current motion in progress.
  //
  // Example: scribbler.arc_now(100, 50) 'Immediately arc a bit to the left by 100 scribbler angle
  //                              'units with a 25mm radius.
  r = (ccw_units * (radius + Wheel_space[0])) / Wheel_space[0];
  l = (ccw_units * (radius - Wheel_space[0])) / Wheel_space[0];
  scribbler_move_now(l, r, 0, Current_spd[0], 0);
}

int32_t scribbler_move(int32_t left_distance, int32_t right_distance, int32_t move_time, int32_t max_speed, int32_t no_stop)
{
  int32_t	max_d, max_pd, max_rvel, max_lvel, end_spd;
  int32_t result = 0;
  // Base-level non-reactive user move routine. Does not interrupt motion in progress.
  // If called during path construction, velocities will blend. If no path, velocity ramps to zero at end.
  // This method may not return right away if it has to wait for current motion to complete.
  //
  // left_distance: Amount to move left wheel (-32767 - 32767) in 0.5mm (approx.) increments.
  // right_distance: Amount to move right wheel (-32767 - 32767) in 0.5mm (approx.) increments.
  // move_time: If non-zero, time (ms) after which to stop, regardless of distance traveled.
  // max_speed (0 - 15): Maximum speed (after ramping).
  // no_stop: If non-zero, keep running, regardless of distance traveled unless/until timeout or a preemptive change.
  //
  // Example: scribbler.move(10000, 5000, 10000, 7, 0) 'Move in a clockwise arc for 10000/2 mm on outside, or until 10 seconds elapse,
  //                                            '  whichever occurs first, at half speed.
  left_distance = Min__((Max__((-32767), left_distance)), 32767);
  right_distance = Min__((Max__((-32767), right_distance)), 32767);
  max_speed = Min__((Max__(0, max_speed)), 15);
  Current_spd[0] = max_speed;
  if (In_path[0] == 2) {
    if (((left_distance ^ Path_Ldist[0]) & 0x8000) || ((right_distance ^ Path_Rdist[0]) & 0x8000)) {
      end_spd = 0;
    } else {
      max_d = Max__((abs(left_distance)), (abs(right_distance)));
      max_pd = Max__((abs(Path_Ldist[0])), (abs(Path_Rdist[0])));
      /* 
              
       */
      max_rvel = ((Min__(((((abs(right_distance)) * max_speed) + (Shr__(max_d, 1))) / max_d), ((((abs(Path_Rdist[0])) * Path_max_spd[0]) + (Shr__(max_pd, 1))) / max_pd))) * max_d) / (Max__((abs(right_distance)), 1));
      /* 
              
       */
      max_lvel = ((Min__(((((abs(left_distance)) * max_speed) + (Shr__(max_d, 1))) / max_d), ((((abs(Path_Ldist[0])) * Path_max_spd[0]) + (Shr__(max_pd, 1))) / max_pd))) * max_d) / (Max__((abs(left_distance)), 1));
      end_spd = Min__(max_rvel, max_lvel);
    }
    scribbler_run_motors(0, Path_Ldist[0], Path_Rdist[0], Path_time[0], Path_max_spd[0], end_spd);
    result = end_spd;
  }
  if (In_path[0] >= 1) {
    if ((no_stop) && (move_time == 0)) {
      scribbler_run_motors(SCRIBBLER_MOT_CONT, left_distance, right_distance, move_time, max_speed, 0);
      In_path[0] = 0;
    } else {
      Path_Ldist[0] = left_distance;
      Path_Rdist[0] = right_distance;
      Path_time[0] = move_time;
      Path_max_spd[0] = max_speed;
      In_path[0] = 2;
    }
  } else {
    scribbler_run_motors((SCRIBBLER_MOT_CONT & -(no_stop != 0)), left_distance, right_distance, move_time, max_speed, 0);
  }
  return result;
}

void scribbler_wheels_now(int32_t left_velocity, int32_t right_velocity, int32_t move_time)
{
  // Set the wheel speeds preemptively to left_velocity and right_velocity (-255 to 255).
  // If move_time > 0, time out after move_time ms.
  // Interrupts any movement in progress and deletes all path information.
  // This method always returns immediately.
  //
  // Example: scribbler.wheels_now(-255, 255, 5000) 'Turn left, in place, at maximum speed, for five seconds. 
  scribbler_move_now(left_velocity, right_velocity, move_time, (Shr__((Min__((Max__((abs(left_velocity)), (abs(right_velocity)))), 255)), 4)), 1);
}

void scribbler_move_now(int32_t left_distance, int32_t right_distance, int32_t move_time, int32_t max_speed, int32_t no_stop)
{
  // Base-level preemptive user routine for reactive movements (e.g. for line following).
  // Interrupts any movement in progress and deletes all path information.
  // This method always returns immediately. 
  //
  // left_distance: Amount to move left wheel (-32767 - 32767) in 0.5mm (approx.) increments.
  // right_distance: Amount to move right wheel (-32767 - 32767) in 0.5mm (approx.) increments.
  // move_time: If non-zero, time (ms) after which to stop, regardless of distance traveled.
  // max_speed (0 - 15): Maximum speed (after ramping).
  // no_stop: If non-zero, keep running, regardless of distance traveled unless/until timeout or another preemptive change.
  //
  // Example: scribbler.move_now(1000, -1000, 0, 15, 1) 'Rotate in place clockwise at full speed until preempted.  
  In_path[0] = 0;
  scribbler_run_motors((SCRIBBLER_MOT_IMM | (SCRIBBLER_MOT_CONT & -(no_stop != 0))), left_distance, right_distance, move_time, max_speed, 0);
}

void scribbler_stop_now(void)
{
  // Stops movement immediately and deletes all path information.
  //
  // Example: scribbler.stop_now.
  In_path[0] = 0;
  scribbler_run_motors(SCRIBBLER_MOT_IMM, 0, 0, 0, 0, 0);
}

void scribbler_wait_stop(void)
{
  // Wait for all current and pending motions to complete.
  //
  // Example: scribbler.wait_stop
  while (scribbler_moving()) {
    Yield__();
  }
}

int32_t scribbler_stalled(void)
{
  int32_t	stat, mvel, ivel, itime, vstall, istall;
  // Checks whether the scribbler is stalled by testing both the motor current
  // and the activitity of the idler wheel encoder.
  // Returns true if stalled; false if not.
  //
  // Example: repeat until scribbler.stalled 'Execute the repeat block as long as the bot is not stalled.
  if ((stat = Motor_stat[0]) & 0x3) {
    mvel = abs(((stat >> 24) + ((stat << 8) >> 24)));
    itime = (Shr__(stat, 8)) & 0xff;
    if (!((ivel = (stat & 0xfc) << 3))) {
      ivel = 512 / itime;
    }
    if ((vstall = -(((mvel * 14) / ivel) > (20 + Stall_hyst[0])))) {
      Stall_hyst[0] = -2;
    } else {
      Stall_hyst[0] = 2;
    }
    istall = -(scribbler_get_adc_results(SCRIBBLER_ADC_IMOT) > (Shr__((75 * scribbler_get_adc_results(SCRIBBLER_ADC_VBAT)), 7)));
    return -(vstall || istall);
  }
  return 0;
}

int32_t scribbler_moving(void)
{
  // Return TRUE if motion in progress or pending, FALSE if stopped with no pending motions.
  //
  // Example: repeat while scribbler.moving 'Continuously execute the following repeat block until motions are finished.
  return -((Motor_stat[0] & 0x3) != 0);
}

int32_t scribbler_motion(void)
{
  // Return current motion status:
  //
  // 31            24 23           16 15            8 7         2 1 0
  // ┌─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┐
  // │±  Left wheel  │±  Right wheel │  Idler timer  │ Idler spd │Mov│ , where
  // └─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┘
  //
  // Left wheel and right wheel are signed, twos complement eight bit velocity values,
  // Idler timer is the time in 1/10 second since the last idler edge,
  // Idler spd is an unsigned six-bit velocity value, and
  // Mov is non-zero iff one or more motors are turning.
  // Left and right wheel velocities are instanteous encoder counts over a 1/10-second interval.
  // Idler wheel wheel velocity is updated every 1/10 second and represents the idler encoder count during the last 1.6 seconds.
  //
  // Example: left_vel := scribbler.motion ~> 24 'Get the current left wheel velocity as a signed 32-bit value.
  return Motor_stat[0];
}

int32_t scribbler_motion_addr(void)
{
  // Return the address of the status and debug array.
  //
  // Example: longmove(@my_stats, scribbler.motion_addr, 6) 'Copy all status data to the local array my_stats.
  return (int32_t)(Motor_stat);
}

int32_t scribbler_move_ready(void)
{
  // Return TRUE if a new motion command can be accepted without waiting, FALSE if a command is still pending.
  //
  // Example: repeat until scribbler.move_ready 'Continuously execute the following repeat block until a new move can be accepted.
  return -(Motor_cmd[0] == 0);
}

void scribbler_run_motors(int32_t command, int32_t left_distance, int32_t right_distance, int32_t timeout, int32_t max_speed, int32_t end_speed)
{
  /*  Base level motor activation routine. Normally, this method is not called by the user but is called by the
       several convenience methods available to the user.
    
   */
  //
  // `command: the OR of any or all of the following:
  //
  //   MOT_IMM:   Commanded motion starts immediately, without wating for prior motion to finish.
  //   MOT_CONT:  Commanded motion will continue to run at wheel ratio given by left and right distances,
  //                even after distances are covered.
  //
  // `left_distance, `right_distance (-32767 to 32767):
  //
  //
  //   The distances to be covered by the left and right wheels, respectively. Units are approximately 0.5mm.
  //
  // `timeout (0 - 65535): If non-zero, time limit (ms) after which motion stops, regardless of distance covered.
  //
  // `max_speed (0 - 15): Peak velocity to be reached during motion profile.
  //
  // `end_speed (0 - 15):
  //
  //   Velocity to be attained at end of motion profile. If non-zero, this is the velocity needed to
  //   segue smoothly into the next motion profile. end_speed should never be greater than max_speed.
  //
  // `Example: scribbler.run_motors(scribbler#MOT_CONT | scribbler#MOT_TIMED, 100, -100, 5000, 8, 0) 'Turn in place clockwise for 5 seconds at half speed. 
  if (command & SCRIBBLER_MOT_IMM) {
    ((int32_t *)(int32_t)(Motor_Rdist))[0] = 0;
    ((int32_t *)(int32_t)(Motor_cmd))[0] = 0;
  } else {
    while (((int32_t *)(int32_t)(Motor_cmd))[0]) {
      Yield__();
    }
  }
  Motor_Rdist[0] = Min__((Max__((-32767), right_distance)), 32767);
  Motor_Ldist[0] = Min__((Max__((-32767), left_distance)), 32767);
  ((int32_t *)(int32_t)(Motor_cmd))[0] = (((timeout << 16) | ((Min__((Max__(0, max_speed)), 15)) << 8)) | ((Min__((Max__(0, end_speed)), 15)) << 4)) | (command & (SCRIBBLER_MOT_IMM | SCRIBBLER_MOT_CONT));
  if ((left_distance) || (right_distance)) {
    timeout = CNT;
    while (!((scribbler_moving()) || ((CNT - timeout) > 800000))) {
      Yield__();
    }
  }
}

//
//
// -------[ Sensor methods... ]-------------------------------------------------
//
// Sensor methods return information about the scribbler's various onboard sensors.
//
/*  `NOTE: The following obstacle threshold methods affect only the obstacle sensor threshold used when
   `obstacle is called with a threshold value of zero.
 */
int32_t scribbler_read_obstacle_threshold(void)
{
  int32_t _local__0007[1];
  /*  Read the obstacle threshold value from EEPROM, and substitute it for the
       default if the checksum is correct and the value is within reasonable bounds.
       Returns the threshold value read on success.
       If no valid calibration values exist in EEPROM, sets to (and returns) the
       default value, DEFAULT_OBSTACLE_THLD.
    ''
    '' `Example: scribbler.read_obstacle_threshold
    ''
    ''     Get previously-written obstacle threshold value.
    
   */
  if (scribbler__ee_rdblock((int32_t)(&_local__0007[0]), SCRIBBLER_EE_OBSTACLE_THLD, 1)) {
    _local__0007[0] &= 0xff;
    if ((_local__0007[0] > 0) && (_local__0007[0] <= 100)) {
      return scribbler_set_obstacle_threshold(_local__0007[0]);
    }
  }
  return scribbler_default_obstacle_threshold();
}

int32_t scribbler_write_obstacle_threshold(void)
{
  /*  Write the current obstacle threhsold value to EEPROM.
       Returns true on a successful write; false otherwise.
    ''
    '' `Example: scribbler.write_obstacle_threshold
    ''
    ''     Write current obstacle threshold value to EEPROM.
    
   */
  return scribbler__ee_wrblock((int32_t)(Obstacle_thld), SCRIBBLER_EE_OBSTACLE_THLD, 1);
}

int32_t scribbler_default_obstacle_threshold(void)
{
  /*  Restore the obstacle threshold to its default value. DOES NOT SAVE IN EEPROM.
       This method is optional unless `read_obstacle_threshold or `set_obstacle_threshold
       has been called successfully. Returns the default value, DEFAULT_OBSTACLE_THRESHOLD.
    ''
    '' `Example: scribbler.default_obstacle_threshold
    ''
    ''     Restore calibration default.
    
   */
  return scribbler_set_obstacle_threshold(SCRIBBLER_DEFAULT_OBSTACLE_THLD);
}

int32_t scribbler_set_obstacle_threshold(int32_t thld)
{
  /*  Set the obstacle sensor threshold to thld. DOES NOT SAVE IN EEPROM. Returns the value set.
    ''  
    '' `Example: scribbler.set_obstacle_threhsold(10)
    ''
    ''     Set obstacle sensor threshold to 10.
    ''
       This becomes the value used when the `obstacle method is called with an argument of zero.
    
   */
  return (Obstacle_thld[0] = thld);
}

int32_t scribbler_get_obstacle_threshold(void)
{
  // Returns the current obstacle sensor threshold.
  //
  // `Example: Thld := scribbler.get_obstacle_threshold
  //
  //     Set `Thld to the current obstacle threshold.
  return Obstacle_thld[0];
}

int32_t scribbler_obstacle(scribbler *self, int32_t side, int32_t threshold)
{
  int32_t result = 0;
  // Return the value of the obstacle detection: `true = obstacle; `false = no obstacle.
  // 
  // `side (LEFT or RIGHT): Select the side to check.
  // `threshold (0 - 100): Set the threshold of the  detection. At high threshold values,
  //     only very close objects will be detected. At low values, farther objects (and possibly
  //     the rolling surface itself) will be detected. If `threshold == 0 the default (or
  //     calibration) threshold setting will be used. 
  //
  // `Example: obstacle_both := scribbler.obstacle(scribbler#LEFT, 0) and scribbler.obstacle(scribbler#RIGHT, 0)
  //
  //     Obstacle_both is set on left AND right obstacles, using the default sensitivity.
  if (!(threshold)) {
    threshold = Obstacle_thld[0];
  }
  threshold = Min__((Max__(threshold, 1)), 100);
  FRQA = (14000 * threshold) + (20607 * (100 - threshold));
  if (side == SCRIBBLER_LEFT) {
    CTRA = (4 << 26) | SCRIBBLER_OBS_TX_LEFT;
    DIRA |= (1 << SCRIBBLER_OBS_TX_LEFT);
  } else {
    if (side == SCRIBBLER_RIGHT) {
      CTRA = (4 << 26) | SCRIBBLER_OBS_TX_RIGHT;
      DIRA |= (1 << SCRIBBLER_OBS_TX_RIGHT);
    }
  }
  _waitcnt((CNT + 24000));
  result = -(((INA >> SCRIBBLER_OBS_RX) & 0x1) == 0);
  DIRA &= (~(1 << SCRIBBLER_OBS_TX_LEFT));
  DIRA &= (~(1 << SCRIBBLER_OBS_TX_RIGHT));
  CTRA = 0;
  _waitcnt((CNT + (CLKFREQ / 1000)));
  return result;
}

/*  `NOTE: The following line_threshold methods affect only the line sensor threshold used when
   line_sensor is called with a threshold value of zero.
 */
int32_t scribbler_read_line_threshold(void)
{
  int32_t _local__0008[1];
  // Read the line threshold value from EEPROM, and substitute it for the default
  // if checksum is correct and value is reasonable.
  // Returns the threshold value read on success.
  // If no valid calibration values exist in EEPROM, sets to (and returns)the
  // default value DEFAULT_LINE_THLD.
  //
  // Example: scribbler.read_line threshold 'Get previously-written line threshold value.
  if (scribbler__ee_rdblock((int32_t)(&_local__0008[0]), SCRIBBLER_EE_LINE_THLD, 1)) {
    _local__0008[0] &= 0xff;
    if ((_local__0008[0] > 5) && (_local__0008[0] < 100)) {
      return scribbler_set_line_threshold(_local__0008[0]);
    }
  }
  return scribbler_default_line_threshold();
}

int32_t scribbler_write_line_threshold(void)
{
  // Write current line threhsold value to EEPROM.
  // Returns true on a successful write; false otherwise.
  //
  // Example: scribbler.write_line_threshold 'Write current line threshold value to EEPROM.
  return scribbler__ee_wrblock((int32_t)(Line_thld), SCRIBBLER_EE_LINE_THLD, 1);
}

int32_t scribbler_default_line_threshold(void)
{
  // Restore line threshold to default value. DOES NOT SAVE IN EEPROM.
  // This method is optional unless read_line_threshold or set_line_threshold
  // have been called successfully.
  // Returns the default value.
  //
  // Example: scribbler.default_line_threshold 'Restore calibration default.
  return scribbler_set_line_threshold(SCRIBBLER_DEFAULT_LINE_THLD);
}

int32_t scribbler_set_line_threshold(int32_t thld)
{
  // Set line sensor threshold to thld.
  // DOES NOT SAVE IN EEPROM. Returns the value set.
  //
  // Example: scribbler.set_line_threhsold(32) 'Set line sensor threshold to 32.
  //
  // This becomes the value used when the line_sensor method is called with an argument of zero.
  return (Line_thld[0] = thld);
}

int32_t scribbler_get_line_threshold(void)
{
  // Returns the current line sensor threshold.
  //
  // Example: Thld := scribbler.get_line_threshold
  return Line_thld[0];
}

int32_t scribbler_line_sensor(int32_t side, int32_t threshold)
{
  int32_t result = 0;
  // If threshold => 0
  //   Return the value of the line sensor on side (LEFT or RIGHT),
  //   compared to the threshold. (If threshold is zero, substitute 40.)
  //   Return: false == dark; true == light
  // If threshold < 0
  //   Return analog value of line sensor.
  //
  // Example: if (scribbler.line_sensor(scribbler#LEFT, 0)) 'IF block executed if left line sensor seeing default bright reflection.
  if (side == SCRIBBLER_LEFT) {
    result = Shr__(((uint16_t *)results_addr[0])[SCRIBBLER_ADC_LEFT_LIN], 8);
  } else {
    if (side == SCRIBBLER_RIGHT) {
      result = Shr__(((uint16_t *)results_addr[0])[SCRIBBLER_ADC_RIGHT_LIN], 8);
    }
  }
  if (threshold == 0) {
    result = -(result >= Line_thld[0]);
  } else {
    if (threshold > 0) {
      result = -(result >= threshold);
    }
  }
  return result;
}

int32_t scribbler_read_light_calibration(void)
{
  int32_t _local__0009[1];
  // Read light calibration values from EEPROM, and use them if they're reasonable.
  // Returns the calibration values (packed long) on success.
  // If no valid calibration values exist in EEPROM, sets to (and returns)the
  // default values.
  //
  // Example: scribbler.read_light_calibration 'Get previously-written light calibration values.
  if (scribbler__ee_rdblock((int32_t)(&_local__0009[0]), SCRIBBLER_EE_LIGHT_CALIB, 3)) {
    return scribbler_set_light_calibration(((_local__0009[0] << 24) >> 24), ((_local__0009[0] << 16) >> 24), ((_local__0009[0] << 8) >> 24));
  } else {
    return scribbler_default_light_calibration();
  }
}

int32_t scribbler_write_light_calibration(void)
{
  int32_t _local__0010[1];
  // Write current light calibration values to EEPROM.
  // Returns true on a successful write; false otherwise.
  //
  // Example: scribbler.write_light_calibration 'Write current light calibration values to EEPROM.
  _local__0010[0] = scribbler_get_light_calibration();
  return scribbler__ee_wrblock((int32_t)(&_local__0010[0]), SCRIBBLER_EE_LIGHT_CALIB, 3);
}

int32_t scribbler_default_light_calibration(void)
{
  // Restore light calibration to default values. DOES NOT SAVE IN EEPROM.
  // This method is optional unless read_light_calibration or set_light_calibration
  // have been called successfully.
  // Returns a packed long containing the default values.
  //
  // Example: scribbler.default_light_calibration 'Restore calibration defaults.
  return scribbler_set_light_calibration(SCRIBBLER_DEFAULT_LIGHT_SCALE, SCRIBBLER_DEFAULT_LIGHT_SCALE, SCRIBBLER_DEFAULT_LIGHT_SCALE);
}

int32_t scribbler_set_light_calibration(int32_t left_scale, int32_t center_scale, int32_t right_scale)
{
  int32_t _parm__0011[4];
  _parm__0011[0] = left_scale;
  _parm__0011[1] = center_scale;
  _parm__0011[2] = right_scale;
  // Set light calibration values to method's arguments (-128 to 127).
  // DOES NOT SAVE IN EEPROM. Returns a packed long containing the new values.
  //
  // Example: scribbler.set_light_calibration(-5, 25, 0) 'Set left scale to -5,
  //                                              'center scale to 25, and
  //                                              'right scale to 0.
  //
  // Calibration values are signed and are added to the results of the light_sensor_log method.
  for(_parm__0011[3] = 0; _parm__0011[3] <= 2; _parm__0011[3]++) {
    Light_scale[_parm__0011[3]] = Min__((Max__((&_parm__0011[0])[_parm__0011[3]], (-128))), 127);
  }
  return scribbler_get_light_calibration();
}

int32_t scribbler_get_light_calibration(void)
{
  // Returns a packed long containing the current light calibration values:
  //
  //  31          24 23          16 15           8 7           0
  // ┌──────────────┬──────────────┬──────────────┬─────────────┐    
  // │       0      │  Right Scale │ Center Scale │  Left Scale │
  // └──────────────┴──────────────┴──────────────┴─────────────┘
  //
  // Example: CenterCal := (scribbler.get_light_calibration >> 8) & $ff
  return ((Light_scale[0] | (Light_scale[1] << 8)) | (Light_scale[2] << 16));
}

int32_t scribbler_light_sensor(int32_t side)
{
  int32_t result = 0;
  // Return the square root (0 .. 255) of the value of the light sensor on side (LEFT, CENTER, or RIGHT).
  // The square-root-scaled value provides a wider dynamic range over a small numerical range than the
  // raw values do.
  //
  // Example: if (scribbler.light_sensor(scribbler#LEFT) > scribbler.light_sensor(scribbler#RIGHT)) 'IF block executed if uncalibrated left is brighter than right.
  if ((result = scribbler_light_sensor_word(side)) == SCRIBBLER_UNDEF) {
    return 0;
  }
  result = Sqrt__(result);
  return result;
}

int32_t scribbler_light_sensor_log(int32_t side)
{
  int32_t	wsense, lsense, ssense, mant, Char;
  int32_t result = 0;
  static int32_t look__0001[] = {SCRIBBLER_LEFT, SCRIBBLER_CENTER, SCRIBBLER_RIGHT, };

  // Return a log-like function (0 .. 255) of the value of the light sensor on side (LEFT, CENTER, or RIGHT).
  // The log-scaled value provides a wider dynamic range over a small numerical range than the
  // raw values do and more sensitivity to change at lower light levels than the square-root funciton above.
  //
  // Example: if (scribbler.light_sensor_log(scribbler#LEFT) > scribbler.light_sensor_log(scribbler#RIGHT)) 'IF block executed if calibrated left is brighter than right.
  if ((wsense = scribbler_light_sensor_word(side)) == SCRIBBLER_UNDEF) {
    return 0;
  }
  if ((Char = (BitEncode__(wsense)) - 1) < 0) {
    return 0;
  }
  lsense = Shr__((wsense << (31 - Char)), 20);
  mant = ((uint16_t *)(49152 + ((lsense & 0x7ff) << 1)))[0];
  lsense = Min__(((((Char << 4) | (Shr__(mant, 12))) << 8) / 245), 255);
  ssense = Sqrt__((Min__(((wsense << 15) / 30000), 65535)));
  result = Min__((Max__(((((ssense * (255 - ssense)) + (lsense * ssense)) / 255) + ((Light_scale[Lookdown__(side, 0, look__0001, 3)] << 24) >> 24)), 0)), 255);
  return result;
}

int32_t scribbler_light_sensor_raw(int32_t side)
{
  int32_t result = 0;
  // Return the raw value (0 .. 4095) of the light sensor on side (LEFT, CENTER, or RIGHT).
  //
  // Example: if (scribbler.light_sensor_raw(scribbler#LEFT) > scribbler.light_sensor(scribbler#RIGHT)) 'IF block executed if left is brighter than right.
  if ((result = scribbler_light_sensor_word(side)) == SCRIBBLER_UNDEF) {
    return 0;
  }
  result = Shr__(result, 4);
  return result;
}

int32_t scribbler_light_sensor_word(int32_t side)
{
  if (side == SCRIBBLER_LEFT) {
    return ((uint16_t *)results_addr[0])[SCRIBBLER_ADC_LEFT_LGT];
  } else {
    if (side == SCRIBBLER_CENTER) {
      return ((uint16_t *)results_addr[0])[SCRIBBLER_ADC_CENTER_LGT];
    } else {
      if (side == SCRIBBLER_RIGHT) {
        return ((uint16_t *)results_addr[0])[SCRIBBLER_ADC_RIGHT_LGT];
      } else {
        return SCRIBBLER_UNDEF;
      }
    }
  }
}

int32_t scribbler_get_results(int32_t index)
{
  // General accessor for ADC Results array: returns the full word value.
  //
  // Example: battery_level := scribbler.get_adc_results(scribbler#ADC_VBAT) 'Query the battery voltage and save in battery_level.
  return ((uint16_t *)results_addr[0])[index];
}

int32_t scribbler_get_adc_results(int32_t index)
{
  // General accessor for ADC Results array: returns upper eight bits of word value.
  //
  // Example: battery_level := scribbler.get_adc_results(scribbler#ADC_VBAT) 'Query the battery voltage and save in battery_level.
  return (Shr__(((uint16_t *)results_addr[0])[index], 8));
}

//
//
// -------[ Button methods... ]-------------------------------------------------
//
// Button methods control and sense the user's interaction with the scribbler's push button.
int32_t scribbler_button_press(void)
{
  // Return true if button is down, false if button is up.
  //
  // Example: if(scribbler.button_press) 'IF block executed if button is down.
  return -(((INA >> SCRIBBLER_BUTTON) & 0x1) == 0);
}

int32_t scribbler_button_count(void)
{
  int32_t result = 0;
  // Get the last count of button presses (0 - 8). Then zero the count.
  //
  // Example: button_presses := scribbler.button_count 'Button_presses is set to the recent button press count, which is then zeroed.
  if ((result = ((uint8_t *)results_addr[0])[0x2c])) {
    ((uint8_t *)results_addr[0])[0x2c] = 0;
  }
  return result;
}

int32_t scribbler_reset_button_count(void)
{
  // Return the reset button count (0- 8). Zero indicates a power-on or PC-initiated reset.
  //
  // Example: reset_button_presses := scribbler.reset_button_count 'Reset_button_presses is set to the button press count that caused the reset.
  return Reset_count[0];
}

void scribbler_button_mode(int32_t led_enable, int32_t reset_enable)
{
  ((uint8_t *)results_addr[0])[0x2d] = (SCRIBBLER_LED_ENA & -(led_enable != 0)) | (SCRIBBLER_RST_ENA & -(reset_enable != 0));
}

//
//
// -------[ LED methods... ]----------------------------------------------------
//
// LED methods control the red/green user LEDs and blue power LED.
void scribbler_set_leds(int32_t left_color, int32_t center_color, int32_t right_color, int32_t power_color)
{
  // Sets all LEDs for which the color argument <> NO_CHANGE (-1).
  // See the above constants for predefined indices and colors.
  //
  // Example: scribbler.set_leds(scribbler#RED, scribbler#NO_CHANGE, scribbler#BLINK_GREEN, scribbler#OFF) 'Set LEDs (L to R): RED, same, blinking GREEN, off.
  if (left_color != SCRIBBLER_NO_CHANGE) {
    scribbler_set_led(SCRIBBLER_LEFT, left_color);
  }
  if (center_color != SCRIBBLER_NO_CHANGE) {
    scribbler_set_led(SCRIBBLER_CENTER, center_color);
  }
  if (right_color != SCRIBBLER_NO_CHANGE) {
    scribbler_set_led(SCRIBBLER_RIGHT, right_color);
  }
  if (power_color != SCRIBBLER_NO_CHANGE) {
    scribbler_set_led(SCRIBBLER_POWER, power_color);
  }
}

void scribbler_set_led(int32_t index, int32_t color)
{
  int32_t	shift;
  ((uint8_t *)((results_addr[0] + (SCRIBBLER_LED_BYTES << 1)) + (index & 0x3)))[0] = color;
}

//
//
// -------[ Sound methods... ]--------------------------------------------------
//
// Sound methods control the output from the scribbler's built-in speaker.
int32_t scribbler_beep(void)
{
  // Set volume level to 50%, and send a 150ms 1 KHz tone, followed by a 350ms pause.
  //
  // Example: scribbler.beep 'Make the speaker beep.
  scribbler_set_volume(50);
  scribbler_set_voices(SCRIBBLER_SIN, SCRIBBLER_SIN);
  scribbler_play_tone(150, 1000, 0);
  return scribbler_play_tone(350, 0, 0);
}

void scribbler_command_tone(int32_t cmd_tone)
{
  // Send an immediate command (cmd_tone) to the sound cog:
  //
  //   STOP:  Stops sound production immediately, then clears the sound queue.
  //   PAUSE: Pauses sound production after the note currently being played.
  //   PLAY:  Resumes sound production from the queue.
  //
  // Example: scribbler.command_tone(STOP) 'Cause sounds to cease immediately.
  switch(cmd_tone) {
  case SCRIBBLER_STOP:
  case SCRIBBLER_PAUSE:
  case SCRIBBLER_PLAY:
    Tone_cmd[0] = cmd_tone;
    while (Tone_cmd[0]) {
      Yield__();
    }
    if (cmd_tone == SCRIBBLER_STOP) {
      Tone_enq_ptr[0] = Tone_deq_ptr[0];
    }
    break;
  }
}

int32_t scribbler_set_volume(int32_t vol)
{
  // Set the current volume level to vol (0 - 100) percent.
  //
  // Example: scribbler.set_volume(50) 'Set volume level to 50%.
  return scribbler__enqueue_tone((0x2000 | (((Min__((Max__(vol, 0)), 100)) * 8191) / 100)));
}

void scribbler_set_voices(int32_t v1, int32_t v2)
{
  // Set voices for both channels (SQU, SAW, TRI, SIN)
  //
  // Example: scribbler.set_voices(scribbler#SIN, scribbler#TRI) 'Set voice 1 to sine wave; voice 2 to triangle wave.
  Tone_voice1[0] = v1 & 0x3;
  Tone_voice2[0] = v2 & 0x3;
}

int32_t scribbler_play_sync(int32_t value)
{
  // Insert a SYNC command into the sound queue.
  // When the sound processor encounters it, it writes value (0 - 255) to
  // the hub variable Tone_sync, then continues. This method can be used to
  // synchronize motion to the sound being played.
  //
  // Example: scribbler.play_sync(12)    'Insert a SYNC 12 into the tone queue.
  //                              'When encountered during play, player will set the sync value to 12
  //                              '(for get_sync) and continue with the next command.
  return scribbler__enqueue_tone((0x4000 | (value & 0xff)));
}

int32_t scribbler_play_pause(int32_t value)
{
  // Insert a PAUS command into the sound queue.
  // When the sound processor encounters it, it writes value (0 - 255) to
  // the hub variable Tone_sync, then pauses.
  //
  // Example: scribbler.play_pause(12)   'Insert a PAUS 12 into the tone queue.
  //                              'When encountered during play, player will set the sync value to 12
  //                              '(for get_sync) and wait for a PLAY command to resume.
  return scribbler__enqueue_tone((0x6000 | (value & 0xff)));
}

int32_t scribbler_get_sync(void)
{
  int32_t result = 0;
  // Get the current Tone_sync value.
  //
  // Example: current_sync := scribbler.get_sync 'Get the latest sync value written from tone queue while playing,
  //                                      'then zero the value if it was non-zero.
  if ((result = Tone_sync[0])) {
    Tone_sync[0] = 0;
  }
  return result;
}

int32_t scribbler_play_tone(int32_t time, int32_t frq1, int32_t frq2)
{
  // Send sound to speaker, mixing frq1 & frq2 (1 - 10000 Hz),
  // using current voices and volume for time (0 - 8191 milliseconds).
  //
  // Example: scribbler.play_tone(1000, 440, 880) 'Play an A440 and A880 for 1000 milliseconds.
  if (!(time)) {
    return 0;
  }
  scribbler__enqueue_tone((time & 0x1fff));
  scribbler__enqueue_tone(((Tone_voice1[0] << 14) | (frq1 & 0x3fff)));
  return scribbler__enqueue_tone(((Tone_voice2[0] << 14) | (frq2 & 0x3fff)));
}

int32_t scribbler_play_tones(int32_t addr)
{
  int32_t result = 0;
  // Add a command sequence to the tone queue. Commands are of the
  // following format:
  //
  // 15  13 12                      0
  // ┌─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┐
  // │ Cmd │          Data           │
  // └─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┘
  //
  // Cmd: %000
  //
  //   Play tone for duration Data (0 - 8192ms),using the following TWO words as
  //   the voices, each having the following format:
  //
  //    15 14 13                        0
  //     ┌─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┬─┐
  //     │Voc│         Frequency         │
  //     └─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┴─┘
  //
  //      Voc (voice):
  //
  //        00 = square wave
  //        01 = sawtooth wave
  //        10 = triangle wave
  //        11 = sine wave
  //
  //     Frequency : 0 (no sound) to 16363 Hz.
  //
  // Cmd: %001
  //
  //   Set volume to Data << 3 (range 0 - 0.9998)
  //
  // Cmd: %010
  //
  //   Set sync to Data & $ff
  //
  // Cmd: %011
  //
  //   Set sync to Data & $ff, then PAUSE.
  //
  // Example: scribbler.play_tones(@tone_buffer) 'Add tones from tone_buffer (word array) to tone queue until a zero word is encountered.         
  while (((uint16_t *)addr)[0]) {
    result = scribbler__enqueue_tone(((uint16_t *)addr)[0]);
    addr = addr + 2;
  }
  return result;
}

void scribbler_wait_sync(int32_t value)
{
  // Wait for sync in queue to echo (value <> 0) or for queue to become empty (value == 0).
  //
  // Example: scribbler.wait_sync(12) 'Wait until a sync value of 12 is returned from the tone queue.
  if (Tone_cog[0]) {
    if (value) {
      while (!(Tone_sync[0] == value)) {
        Yield__();
      }
    } else {
      while (!(Tone_deq_ptr[0] == Tone_enq_ptr[0])) {
        Yield__();
      }
    }
  }
}

//
//
// -------[ Time methods... ]---------------------------------------------------
//
// Time methods control and sense the scribbler's built-in millisecond timers and provide
// a convenient delay function.
void scribbler_start_timer(int32_t number)
{
  // Start a 1 KHz count-up timer number (0 - 7), which counts up from zero
  // by one every millisecond.
  //
  // Example: scribbler.start_timer(4) 'Restarts timer number four from zero.
  if ((number >= 0) && (number < 8)) {
    Timers[number] = ((int32_t *)(results_addr[0] + 0xa))[0];
  }
}

int32_t scribbler_get_timer(int32_t number)
{
  // Return the time (in milliseconds, up to 2 million seconds ~ 24 days) from the 1 KHz count-up timer number (0 - 7).
  // If number is outside the range 0 - 7, return the value of the master timer, which starts at 0 when scribbler is started.
  //
  // Example: elapsed_time := scribbler.get_timer(4) 'Get time elapsed since Propeller reset or timer restart.
  return (((int32_t *)(results_addr[0] + 0x28))[0] - (Timers[number] & -(-(number >= 0) && -(number < 8))));
}

void scribbler_delay_tenths(scribbler *self, int32_t time)
{
  int32_t	time0, _idx__0012, _limit__0013;
  // Time delay in tenths of a second.
  //
  // Example: scribbler.delay_tenths(20) 'Wait a couple seconds.
  time0 = CNT;
  for(( (_idx__0012 = 0), (_limit__0013 = time) ); _idx__0012 < _limit__0013; _idx__0012++) {
    _waitcnt((time0 = time0 + (CLKFREQ / 10)));
  }
}

//
//
// -------[ EEPROM methods... ]-------------------------------------------------
//
// EEPROM methods allow read/write access to the auxilliary 32Kbyte EEPROM.
int32_t scribbler_ee_read_byte(int32_t addr)
{
  // Read byte from aux EEPROM at addr.
  //
  // Example: my_data := scribbler.ee_read_byte($2000) 'Set my_data equal to byte at location $2000 in auxilliary EEPROM.
  return scribbler__ee_rdbyte(addr);
}

int32_t scribbler_ee_write_byte(int32_t addr, int32_t data)
{
  // Write byte to aux EEPROM at addr, if addr is in user area.
  //
  // Example: scribbler.ee_write_byte(scribbler#EE_USER_AREA + 5, 35) 'Write the value 35 to the sixth byte in the auxilliary EEPROM's user area.
  if (addr >= SCRIBBLER_EE_USER_AREA) {
    scribbler__ee_wrbyte(addr, data);
    return -1;
  } else {
    return 0;
  }
}

//
//
// -------[ hardware model methods... ]-----------------------------------------
//
int32_t scribbler_get_model_s2(void)
{
  // Returns True if the Robot is an S2
  //  Example: if scribbler.get_model_s2
  //             sio.str(string("My Robot is an S2!"))
  return -(Model_number[0] == SCRIBBLER_MODEL_S2);
}

int32_t scribbler_get_model_s3(void)
{
  // Returns True if the Robot is an S3
  //  Example: if scribbler.get_model_s3
  //   sio.str(string("My Robot is an S3!"))
  return -(Model_number[0] == SCRIBBLER_MODEL_S3);
}

//
//
// -------[ S3 specific methods... ]--------------------------------------------
//
int32_t scribbler_set_power_off(void)
{
  // Powers Off the S3 when the USB cable is not connected
  //  Example: scribbler.set_power_off
  if (scribbler_get_model_s3()) {
    // Disable the charger watch dog timer. 
    scribbler__BQ2495_wrbyte(5, 142);
    // Disable the main battery FET
    return scribbler__BQ2495_wrbyte(7, 104);
  } else {
    return 0;
  }
}

int32_t scribbler_get_usb_powered(void)
{
  // Returns True if a USB cable is powering the Scribbler
  //  Example: if scribbler.get_usb_powered
  //             sio.str(string("USB Power Connected"))
  if (scribbler_get_model_s3()) {
    return (scribbler__BQ2495_rdbyte(8) & (1 << 2));
  } else {
    return 0;
  }
}

int32_t scribbler_get_charging(void)
{
  int32_t	Register;
  // Returns True if the Scribbler is charging its battery
  //  Example: if scribbler.get_charging
  //             sio.str(string("Charging"))
  if (scribbler_get_model_s3()) {
    Register = scribbler__BQ2495_rdbyte(8) & 0x30;
    return -(-(Register == 32) || -(Register == 16));
  } else {
    return 0;
  }
}

//
//
// =======[ Private Spin methods... ]==============================================
//
// These private methods are used internally and are not accessible to the user.
//
// -------[ Miscellaneous... ]--------------------------------------------------
static void scribbler__compute_calibration(void)
{
  // Compute other values dependent on Full_circle to save time in methods.
  Half_circle[0] = Shr__(Full_circle[0], 1);
  Qtr_circle[0] = Shr__(Full_circle[0], 2);
  Atan_circle[0] = (Full_circle[0] * 56841) / 100000;
}

static int32_t scribbler__atan2(int32_t y, int32_t x)
{
  int32_t	arg, adder, n;
  int32_t result = 0;
  // Four-quadrant arctangent. Y and X are signed integers.
  // Full_circle is an integer equal to the number of units in a full circle.
  if ((n = BitEncode__((Min__((abs(x)), (abs(y)))))) > 21) {
    x = x >> (n - 21);
    y = y >> (n - 21);
  }
  if ((abs(x)) > (abs(y))) {
    arg = (y << 10) / x;
    adder = Half_circle[0] & -(x < 0);
  } else {
    arg = ((-x) << 10) / y;
    adder = Qtr_circle[0] + (Half_circle[0] & -(y < 0));
  }
  result = (Shr__(((((abs(arg)) * Atan_circle[0]) / (914 + (Shr__((arg * arg), 12)))) + 1), 2)) - -((abs(arg)) >= 960);
  if (arg < 0) {
    result = -result;
  }
  result = result + adder;
  result = result + (Full_circle[0] & -(result < 0));
  return result;
}

static int32_t scribbler__enqueue_tone(int32_t tone_word)
{
  int32_t	next_ptr;
  // Wait for tone queue to become non-full,
  // then add tone_word to it.
  if (Tone_cog[0]) {
    next_ptr = Tone_enq_ptr[0] + 1;
    next_ptr &= -(next_ptr < SCRIBBLER__TONE_Q_SIZE);
    while (!(Tone_deq_ptr[0] != next_ptr)) {
      Yield__();
    }
    Tone_queue[Tone_enq_ptr[0]] = tone_word;
    Tone_enq_ptr[0] = next_ptr;
    return ((Tone_enq_ptr[0] << 16) | Tone_deq_ptr[0]);
  }
  return 0;
}

// -------[ I2C Methods... ]----------------------------------------------------
static int32_t scribbler__i2c_rd(int32_t acknak)
{
  int32_t	_idx__0014, _mask_0015;
  int32_t result = 0;
  _mask_0015 = 1 << SCRIBBLER_SDA;
  for(_idx__0014 = 0; _idx__0014 < 8; _idx__0014++) {
    OUTA |= (1 << SCRIBBLER_SCL);
    result = (result << 1) | ((INA >> SCRIBBLER_SDA) & 0x1);
    OUTA &= (~(1 << SCRIBBLER_SCL));
  }
  if (-(acknak != 0) & 0x1) {
    DIRA |= _mask_0015;
  } else {
    DIRA &= (~_mask_0015);
  }
  OUTA |= (1 << SCRIBBLER_SCL);
  OUTA &= (~(1 << SCRIBBLER_SCL));
  DIRA &= (~(1 << SCRIBBLER_SDA));
  return result;
}

static int32_t scribbler__i2c_wr(int32_t data)
{
  int32_t	_mask_0016, _idx__0017;
  int32_t result = 0;
  _mask_0016 = 1 << SCRIBBLER_SDA;
  for(_idx__0017 = 0; _idx__0017 < 8; _idx__0017++) {
    if (-(((data = data << 1) & 0x100) == 0) & 0x1) {
      DIRA |= _mask_0016;
    } else {
      DIRA &= (~_mask_0016);
    }
    OUTA |= (1 << SCRIBBLER_SCL);
    OUTA &= (~(1 << SCRIBBLER_SCL));
  }
  DIRA &= (~(1 << SCRIBBLER_SDA));
  OUTA |= (1 << SCRIBBLER_SCL);
  result = -(((INA >> SCRIBBLER_SDA) & 0x1) == 0);
  OUTA &= (~(1 << SCRIBBLER_SCL));
  return result;
}

static void scribbler__i2c_start(void)
{
  DIRA &= (~(1 << SCRIBBLER_SDA));
  OUTA |= (1 << SCRIBBLER_SCL);
  DIRA |= (1 << SCRIBBLER_SDA);
  OUTA &= (~(1 << SCRIBBLER_SCL));
}

static void scribbler__i2c_stop(void)
{
  OUTA &= (~(1 << SCRIBBLER_SCL));
  DIRA |= (1 << SCRIBBLER_SDA);
  OUTA |= (1 << SCRIBBLER_SCL);
  DIRA &= (~(1 << SCRIBBLER_SDA));
}

// -------[ EEPROM Methods... ]-------------------------------------------------   
static int32_t scribbler__ee_rdblock(int32_t dest_addr, int32_t addr, int32_t size)
{
  int32_t	i, csum, _limit__0018, _step__0019;
  csum = scribbler__ee_rdbyte((addr + size));
  for(( ( ( (i = 0), (_limit__0018 = size - 1) ), (_step__0019 = 1) ), (_step__0019 = ((i >= _limit__0018) ? -_step__0019 : _step__0019)) ); (((0 <= i) && (i <= _limit__0018)) || ((0 >= i) && (i >= _limit__0018))) || (i == 0); i = i + _step__0019) {
    csum = csum + (((uint8_t *)dest_addr)[i] = scribbler__ee_rdbyte((addr + i)));
  }
  return -((csum & 0xff) == 0);
}

static int32_t scribbler__ee_wrblock(int32_t src_addr, int32_t addr, int32_t size)
{
  int32_t	i, data, csum, _limit__0020, _step__0021;
  int32_t result = 0;
  csum = 0;
  result = -1;
  for(( ( ( (i = 0), (_limit__0020 = size - 1) ), (_step__0021 = 1) ), (_step__0021 = ((i >= _limit__0020) ? -_step__0021 : _step__0021)) ); (((0 <= i) && (i <= _limit__0020)) || ((0 >= i) && (i >= _limit__0020))) || (i == 0); i = i + _step__0021) {
    data = ((uint8_t *)src_addr)[i];
    csum = csum - data;
    result &= scribbler__ee_wrbyte((addr + i), data);
  }
  result &= scribbler__ee_wrbyte((addr + size), (csum & 0xff));
  return result;
}

static int32_t scribbler__ee_rdbyte(int32_t addr)
{
  int32_t result = 0;
  scribbler__ee_waddr(addr);
  scribbler__i2c_start();
  if (scribbler_get_model_s2()) {
    scribbler__i2c_wr(163);
  } else {
    scribbler__i2c_wr(161);
    addr = addr + 32768;
  }
  result = scribbler__i2c_rd(SCRIBBLER_NAK);
  scribbler__i2c_stop();
  return result;
}

static int32_t scribbler__ee_wrbyte(int32_t addr, int32_t data)
{
  int32_t result = 0;
  scribbler__ee_waddr(addr);
  result = scribbler__i2c_wr(data);
  scribbler__i2c_stop();
  return result;
}

static void scribbler__ee_waddr(int32_t addr)
{
  if (scribbler_get_model_s2()) {
    do {
      scribbler__i2c_start();
    } while (!(scribbler__i2c_wr(162)));
  } else {
    do {
      scribbler__i2c_start();
    } while (!(scribbler__i2c_wr(160)));
    addr = addr + 32768;
  }
  scribbler__i2c_wr((Shr__(addr, 8)));
  scribbler__i2c_wr((addr & 0xff));
}

// -------[ Charger Methods... ]------------------------------------------------
static int32_t scribbler__BQ2495_rdbyte(int32_t addr)
{
  int32_t result = 0;
  scribbler__BQ2495_waddr(addr);
  scribbler__i2c_start();
  scribbler__i2c_wr(215);
  result = scribbler__i2c_rd(SCRIBBLER_NAK);
  scribbler__i2c_stop();
  return result;
}

static int32_t scribbler__BQ2495_wrbyte(int32_t addr, int32_t data)
{
  int32_t result = 0;
  scribbler__BQ2495_waddr(addr);
  result = scribbler__i2c_wr(data);
  scribbler__i2c_stop();
  return result;
}

static void scribbler__BQ2495_waddr(int32_t addr)
{
  do {
    scribbler__i2c_start();
  } while (!(scribbler__i2c_wr(214)));
  scribbler__i2c_wr((Min__(addr, 10)));
}

// =======[ License ]===========================================================
/* {
┌──────────────────────────────────────────────────────────────────────────────────────┐
│                            TERMS OF USE: MIT License                                 │                                                            
├──────────────────────────────────────────────────────────────────────────────────────┤
│Permission is hereby granted, free of charge, to any person obtaining a copy of this  │
│software and associated documentation files (the "Software"), to deal in the Software │
│without restriction, including without limitation the rights to use, copy, modify,    │
│merge, publish, distribute, sublicense, and/or sell copies of the Software, and to    │
│permit persons to whom the Software is furnished to do so, subject to the following   │
│conditions:                                                                           │
│                                                                                      │
│The above copyright notice and this permission notice shall be included in all copies │
│or substantial portions of the Software.                                              │
│                                                                                      │
│THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,   │
│INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A         │
│PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT    │
│HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF  │
│CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE  │
│OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                                         │
└──────────────────────────────────────────────────────────────────────────────────────┘
 */
